<?php

/**
 * sfArtWidgetFormInput represents an HTML input tag, with rounded corners div's
 *
 */
class sfArtWidgetFormChoice extends sfWidgetFormChoice
{

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $class = 'art-select ' . artArray::getFromArray($attributes, 'class');

        return '<div class="' . $class . '">' . artBox::getBox('horizontal', parent::render($name, $value, $attributes, $errors)) . '</div>';
    }

    /**
     * @param string $value
     * @return sfArtWidgetFormChoice|sfWidget
     */
    public function setLabel($value)
    {
        if ($this->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';

        $this->setOption('label', $value);

        return $this;
    }

}
