<?php

/**
 * sfWidgetFormJQueryMultiSelect represents a multi choice select widget.
 *
 */
class sfArtWidgetFormDoctrineJQueryCascadeMultiSelect extends sfWidgetFormDoctrineChoice
{

    public $widgetName;
    public $slaveName;
    public $ajaxUrl;
    public $master;
    public $last;
    public $generatedName;
    public $slaveFunction;
    public $multiple;

    /**
     * Constructor.
     *
     * Available options:
     *
     *  * model:           The model class (required)
     *  * renderer_class:   The class to use instead of the default ones
     *  * renderer_options: The options to pass to the renderer constructor
     *  * renderer:         A renderer widget (overrides the expanded and renderer_options options)
     *                      The choices option must be: new sfCallable($thisWidgetInstance, 'getChoices')
     * @param array $options     An array of options
     * @param array $attributes  An array of default HTML attributes
     *
     * @see sfWidgetFormChoiceBase
     */
    protected function configure($options = array(), $attributes = array())
    {
        sfContext::getInstance()->getConfiguration()->loadHelpers(array('Url'));

        artWidgetHelper::configureMultiselect($this, $options, $attributes);

        $this->addOption('widget_name', null);
        $this->addOption('slave_name', null);
        $this->addOption('ajax_url', false);
        $this->addOption('master', false);
        $this->addOption('last', false);
        $this->addOption('auto_open', false);

        parent::configure($options, $attributes);
    }

    /**
     * @param  string $name        The element name
     * @param  string $value       The value selected in this widget
     * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
     * @param  array  $errors      An array of errors for the field
     *
     * @return string An HTML tag string
     *
     * @see sfWidgetForm
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $this->getProperties($name);
        $parentRender = parent::render($name, $value, $attributes, $errors);

        $widget = artWidgetHelper::renderMultiselect($this, $parentRender, $name, $value, $attributes, $errors, false) .
            sprintf(<<<EOF
<script type="text/javascript">
  function hideInput(element){
                $(element).find('input').attr('checked', false);
                $(element).css('display','none');
                $(element).find('input').removeClass('visible');
                $(element).find('input').attr('disabled','disabled');
  }
  
  function showInput(element){
                $(element).find('input').removeAttr('disabled');
                $(element).css('display','block');
                $(element).find('input').addClass('visible');
  }
  $(document).ready(function() {
    $("#%1\$s").multiselect(
        %2\$s
    );
//    $("#%1\$s").multiselect("uncheckAll");

EOF
                , $this->generatedName, $this->getOption('config'));

        if (!$this->master) {
            $widget .= sprintf(<<<EOF
$("#%1\$s").parent().find('.ui-multiselect-checkboxes li').each(function(){
              hideInput(this);
        });
EOF
                , $this->generatedName);
        }

        if ($this->ajaxUrl && $this->slaveName || $this->last) {
            $widget .= sprintf(<<<EOF
        $("#%1\$s").parent().find('input').bind('change',  function(){%2\$s_get_options(':checked')});
        $("#%1\$s").parent().find('.ui-multiselect-all').bind('click',  function(){%2\$s_get_options('')});
        $("#%1\$s").parent().find('.ui-multiselect-none').bind('click',  function(){%2\$s_get_options('empty')});
    });
     %3\$s
    </script>
EOF
                , $this->generatedName, $this->widgetName, $this->getJsFunctions()
            );
        } else
            $widget .= '}); </script>';

        return $widget;
    }

    public function setLabel($value)
    {
        return artWidgetHelper::setLabel($this, $value);
    }

    public function getProperties($name)
    {
        $this->widgetName = $this->getOption('widget_name');
        $this->slaveName = $this->getOption('slave_name');
        $this->ajaxUrl = $this->getOption('ajax_url');
        $this->master = $this->getOption('master');
        $this->last = $this->getOption('last');
        $this->generatedName = $this->generateId($name);
        $this->multiple = $this->getOption('multiple');
    }

    public function getJsFunctions()
    {

        $js = null;

        if (!$this->last) {
            $js .= sprintf(<<<EOF
function %3\$s_get_options(option){
        var n='';
        $("#%1\$s").parent().find('input' + option).each(function(){
            n +=$(this).val() + ',';
        });
        var urlPath = '%2\$s?ids=' + n;
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlPath, 
            success: function(json){
                %4\$s_set_options(json);
                %4\$s_get_options(':checked');
            }
        }); 
}
EOF
                , $this->generatedName, url_for($this->ajaxUrl), $this->widgetName, $this->slaveName);
        } else
            $js .= sprintf(<<<EOF
        function %1\$s_get_options(){}
EOF
                , $this->widgetName);

        return $js . $this->getSetOptions();
    }

    public function getSetOptions()
    {
        return sprintf(<<<EOF
function checkLast(val)
{
                  $(val).attr('checked', true);
                  $(val).removeAttr('disabled');
                  $(val).click();
                  $(val).attr('disabled','disabled');
}  
function %4\$s_set_options(parentEl){
        if (parentEl == null){
        
              checkLast($("#%1\$s").parent().find('input:checked:last'));
              $("#%1\$s").parent().find('.ui-multiselect-checkboxes li').each(function(){
                  hideInput(this);
              });
              
        }
        else
        {
          var hide = [];
          var show = [];
          var shownEl = [];
          
        $("#%1\$s").parent().find('input.visible').each(function(index, value){
              shownEl.push($(this).val());
        });
          
          parentEl2 = parentEl.split(',');
          var hide = shownEl.subtract(parentEl2);
          var show = parentEl2.subtract(shownEl);
          var checked;
          
          if ($("#ui-multiselect-%1\$s-option-0").attr('type') == 'radio')
                    $("#%1\$s").multiselect("uncheckAll");
                    
          $("#%1\$s").parent().find('.ui-multiselect-checkboxes li').each(function(index, value){
              val =  $(this).find('input').val();
              if ($.inArray(val, hide)> -1){
                  if ($(this).find('input:checked').length == 1)
                    checked = index;
                    hideInput(this);
              }
          });
          var input = '#ui-multiselect-%1\$s-option-' + checked;
          checkLast(input);
          
                    
          $("#%1\$s").parent().find('.ui-multiselect-checkboxes li').each(function(index, value){
              val =  $(this).find('input').val();    
              if ($.inArray(val, show) > -1){
                    showInput(this);
              }    
          });
          
          %6\$s

        }  
}

EOF
            , $this->generatedName, url_for($this->ajaxUrl), $this->slaveName, $this->widgetName, $this->getOption('master'), $this->getAutoOpening($this->generatedName));
    }

    public function getAutoOpening($generatedName)
    {
        $js = '';

        if ($this->getOption('auto_open'))
            $js = '$("#' . $generatedName . '").multiselect("open");';

        return $js;
    }

}
