<?php

/**
 * sfArtWidgetFormInput represents an HTML input tag, with rounded corners div's
 *
 */
class sfArtWidgetFormDoctrineJQueryMultiSelectPlus extends sfArtWidgetFormDoctrineJQueryMultiSelect
{

  public $popupForm;

  public function configure($options = array(), $attributes = array())
  {
    parent::configure($options, $attributes);

    $this->addOption('class_out_box', false);
    $this->addOption('popup_form', false);
  }

  /**
   * @param  string $name        The element name
   * @param  string $value       The value displayed in this widget
   * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
   * @param  array  $errors      An array of errors for the field
   *
   * @return string An HTML tag string
   *
   * @see sfWidgetFormInput
   */
  public function render($name, $value = null, $attributes = array(), $errors = array())
  {
    $this->popupForm = $this->getOption('popup_form');
    $buttonCancel = __('Anuluj');
    $buttonOk = __('Dodaj');
    $popupTitle = __('add_widget_' . $this->popupForm);

    $js = '<script type="text/javascript">
      $(document).ready(function() {

        $("#addWidgetPopup' . $this->popupForm . '").click(function () { 
            var selectToUpdate = $(this).parent().parent().find("select").attr("id");
            
            $.ajax({
              url:"' . url_for('@get_plus_widget_popup_form?form_to_use=' . $this->popupForm) . '?selectCaller="+selectToUpdate,
              dataType: "html",
              success: function(html) {

              if(document.getElementById("add-widget-popup"))
                  document.getElementById("add-widget-popup").innerHTML = "";
              else
                $("body").append(\'<div id="add-widget-popup"></div>\');

              document.getElementById("add-widget-popup").innerHTML = html;
                
                $("#add-widget-popup").dialog({
                    title: "' . $popupTitle . '" ,
                    modal:true,
                    dialogClass: "arteneo-popup",
                    width: \'auto\',
                    close: function(event, ui){
                      $(this).dialog("destroy");
                    },
                    buttons: { 
                        "' . $buttonCancel . '": function() { $(this).dialog("close"); },
                        "' . $buttonOk . '": function() { $("#add-widget-popup").find("form").submit();}
                      } 
                  });
                  }

          });
          
          return false;
          
        });
      });
                     
  </script>';
    
    $jsOnClick =  '<script type="text/javascript">
      $("#product_base_product_vat_id").bind("multiselectclick", function(event, ui){
	setVatPrices($("#product_base_product_vat_id"));
});
  </script>';

    $plus = '<span class="widgetPlus widgetPlus-' . $this->popupForm . '"><a href="#" id="addWidgetPopup' . $this->popupForm . '">add</a></span>';

    return parent::render($name, $value, $attributes, $errors) . $plus . $js;
  }

}