<?php

/**
 * Description of sfArtWidgetFormEmailsTable
 *
 
 */
class sfArtWidgetFormEmailsTable extends sfWidgetForm
{
  protected function configure($options = array( ), $attributes = array( ))
  {
    $this->addOption('inputs_count',1);
    $this->addRequiredOption('type');

    parent::configure($options, $attributes);
    $this->setOption('type', 'text');
  }

  public function render($name, $value = null, $attributes = array( ), $errors = array( ))
  {
    $js = "
<script type=\"text/javascript\">
  function dynamicInputRemove(ele, event){
    if($('.art_input',$(ele).parent().parent().parent()).length !=1 )
      $(ele).parent().parent().remove();
  }

  function dynamicInputGenerate(ele,html){
    var eleToPut = $(ele).parent().parent().parent().children('tr:first').clone();
    $('.box_center input',eleToPut).attr('value','');
    $(ele).parent().parent().before('<tr>'+eleToPut.html()+'</tr>')
  }

  $(document).ready(function() {
    $('.dynamicRemoveButton').live('click',function(event){
      dynamicInputRemove(this, event)
    });
    $('.dynamicAddButton').live('click',function(){
      dynamicInputGenerate(this)
    })
  });
</script>";
    
    $count = $this->getOption('inputs_count');
    $inputsTable = '<div class="emails-table"><table>';
    
    for($i = 0; $i < $count; $i++)
    {
        $localValue = '';
        $localName = $name . '[]';
        $inputError = '';
        
        if(isset($value[$i]))
          $localValue = $value[$i];
        
        if (in_array($i, sfConfig::get('emptyInputs', array())))
          $inputError = 'Wymagane.';
        else if (in_array($i, sfConfig::get('invalidInputs', array())))
          $inputError = 'Please enter a valid email address';
        else if (in_array($i, sfConfig::get('invitedInputs', array())))
          $inputError = 'This person was invite.';
        else if (in_array($i, sfConfig::get('inviteYourself', array())))
          $inputError = 'You can not invite yourself.';
        else if (in_array($i, sfConfig::get('hasAccountsInputs', array())))
          $inputError = 'User has account in service.';

        $inputsTable .= $this->renderInputTag($localName, $localValue, $attributes, $inputError);
    }
    
    $helpHtml = 'help';
    
    if( isset($attributes['help']) )
      $helpHtml = $attributes['help'];
    
    $inputsTable .= '<tr><td><button class="add_image dynamicAddButton" onclick="return false;"></button></td></tr>';
    
    return $inputsTable.'</table></div>' . $js;
  }
  
  public function renderInputTag($name, $value = null, $attributes = array( ), $error = '')
  {
    return '<tr><td><div class="invite-error">' . __($error) . '</div><div class="art_input"><div class="box_left"></div><div class="box_center">' .
      $this->renderTag('input', array_merge(array(
        'type' => $this->getOption('type'),
        'name' => $name, 
        'value' => __($value)), $attributes)) .
            '</div><div class="box_right"></div></div><button class ="remove_image dynamicRemoveButton"  onclick="return false;"></button></td></tr>'; 
  }

}
