<?php

/**
 * sfArtWidgetFormInput represents an HTML input tag, with rounded corners div's
 *
 */
class sfArtWidgetFormFilterInput extends sfWidgetFormFilterInput
{

  /**
   * @param  string $name        The element name
   * @param  string $value       The value displayed in this widget
   * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
   * @param  array  $errors      An array of errors for the field
   *
   * @return string An HTML tag string
   *
   * @see sfWidgetFormInput
   */
  protected function configure($options = array(), $attributes = array())
  {
    parent::configure($options, $attributes);
    
    $this->setOption('template', '<span class="input-container art_input art-right">' . artBox::beginBox('horizontal_span') . '%input%' . artBox::endBox('horizontal_span') . '</span>');
  }

  public function setLabel($value)
  {
    if ($this->getOption('required'))
      $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
    $this->setOption('label', $value);

    return $this;
  }


}
