<?php

/**
 * sfArtWidgetFormInput represents an HTML input tag, with rounded corners div's
 *
 */
class sfArtWidgetFormInput extends sfWidgetFormInput
{

    /**
     * @param  string $name        The element name
     * @param  string $value       The value displayed in this widget
     * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
     * @param  array  $errors      An array of errors for the field
     *
     * @return string An HTML tag string
     *
     * @see sfWidgetFormInput
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $c = "";
        if (isset($attributes['class']))
            $c = $attributes['class'];

        $s = '<div class="art_input ' . $c . '">' . artBox::beginBox('horizontal') . parent::render($name, $value, $attributes, $errors) . artBox::endBox('horizontal') . '</div>';
        return $s;
    }

    /**
     * @param string $value
     * @return sfArtWidgetFormInput|sfWidget
     */
    public function setLabel($value)
    {
        if ($this->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
        $this->setOption('label', $value);

        return $this;
    }

}
