<?php

/**
 * Description of sfArtWidgetFormInputFileEditable
 *
 
 */
class sfArtWidgetFormInputFileEditable extends sfWidgetFormInputFileEditable
{

    /**
     * @param array $options
     * @param array $attributes
     */
    public function configure($options = array(), $attributes = array())
    {
        parent::configure($options, $attributes);
        $this->setOption('template', '%file% <div id="status-widget-image" class="clear"></div>
    %input%<div class="delete-label">%delete% %delete_label%</div>');
    }

    public function setLabel($value)
    {
        if ($this->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
        $this->setOption('label', $value);

        return $this;
    }

    protected function getFileAsTag($attributes)
    {
        artEscaper::setDefaultInArray($attributes, 'alt', ' ');

        if ($this->getOption('is_image') && file_exists(sfConfig::get('sf_web_dir'). $this->getOption('file_src')) && $this->getOption('file_src') !== '')
            return false !== $this->getOption('file_src') ? $this->renderTag('img', array_merge(array('class' => '', 'src' => $this->getOption('file_src')), $attributes)) : '';
        ;
    }

}
