<?php

class sfArtWidgetFormInputJQueryDate extends sfWidgetForm
{

    /**
     * @param array $options
     * @param array $attributes
     */
    protected function configure($options = array(), $attributes = array())
    {
        $this->addOption('culture', BaseForm::getContext()->getUser()->getCulture());
        $this->addOption('min_year', date("Y") - 10);
        $this->addOption('max_year', date("Y") + 5);
        $this->addOption('jquery_options', '');
        $this->addOption('custom_image', '/arteneo-theme/images/calendar.gif');

        parent::configure($options, $attributes);
    }

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $culture = $this->getOption('culture');
        $minYear = $this->getOption('min_year');
        $maxYear = $this->getOption('max_year');
        $customImage = $this->getOption('custom_image');

        $jqueryOptions = $this->getOption('jquery_options');
        $jqueryOptions = $jqueryOptions == '' ? '' : ',' . $jqueryOptions;

        $attributes = array_merge(
            array(
                'type' => 'text',
                'size' => 9,
                'id' => $id = $this->generateId($name),
                'name' => $name,
                'value' => (is_null($value) || $value == '') ? '' : date("Y-m-d", strtotime($value)),
            ), $attributes);

        return '<div class="art_input">' . artBox::beginBox('horizontal') . $this->renderTag('input', $attributes) . artBox::endBox('horizontal') . '</div>' . sprintf(<<<EOF
<script type="text/javascript">
          $(function() { 
		$( "#%s" ).datepicker(jQuery.extend({}, {
			showOn: "both", 
			buttonImage: "%8\$s",
			buttonImageOnly: true,
                           changeMonth: true,
			changeYear: true,
                           dateFormat: 'yy-m-dd',
                           yearRange: '%s:%s',
                           minDate: '%sy',
                           maxDate: '%sy'
                           %s
		}, 
            jQuery.datepicker.regional["%s"] ));
            });
</script>
EOF
            , $id, $minYear, $maxYear, ($minYear - date('Y')), ($maxYear - date('Y')), $jqueryOptions, $culture, $customImage
        );
    }

}