<?php

class sfArtWidgetFormInputJQueryDateCalendar extends sfArtWidgetFormInputJQueryDate
{

    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $culture = $this->getOption('culture');
        $minYear = $this->getOption('min_year');
        $maxYear = $this->getOption('max_year');

        $attributes = array_merge(
            array(
                'type' => 'text',
                'size' => 9,
                'id' => $id = $this->generateId($name),
                'name' => $name,
                'value' => (is_null($value) || $value == '') ? '' : date("Y-m-d", strtotime($value)),
            ), $attributes);

        $js = sprintf(<<<EOF
<script type="text/javascript">
          $(function() { 
		$( "#inline-datepicker" ).datepicker(jQuery.extend({}, {
            changeMonth: true,
	   changeYear: true,
            dateFormat: "dd.mm.yy",
            maxDate: '+3M',
            minDate: '%s',
            onSelect: function(){
            var newDate = $("#inline-datepicker").datepicker( 'getDate' );
            var newTxtDate = newDate.getFullYear() + '-' + (newDate.getMonth()+1) + '-' + newDate.getDate();
            $( "#inline-datepicker input").val(  newTxtDate );
            }
		}, 
            jQuery.datepicker.regional["%s"] ));
            
            
           
            });
</script>
EOF
            , date('d.m.Y'), $culture
        );

        return '<div class="art_input"> ' . artBox::beginBox('horizontal') . $this->renderTag('input', $attributes) . artBox::endBox('horizontal') . '</div>' . $js;
    }

}