<?php

class sfArtWidgetFormInputJQueryDateRange extends sfWidgetForm
{
    protected function configure($options = array(), $attributes = array())
    {
        $this->addOption('culture', BaseForm::getContext()->getUser()->getCulture());
        $this->addOption('min_year', date("Y") - 10);
        $this->addOption('max_year', date("Y") + 5);

        $this->addOption('date_from', new sfArtWidgetFormInputJQueryDate($options));
        $this->addOption('date_to', new sfArtWidgetFormInputJQueryDate($options));

        parent::configure($options, $attributes);
    }


    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $attributes = array('size' => 27);

        return $this->getOption('date_from')->render($name . '[from]', $value['from'], $attributes, $errors) .
            '' . $this->getOption('date_to')->render($name . '[to]', $value['to'], $attributes, $errors) .
            '<br /><br /><label class="filter_hint">' . __("Date format: yyyy-mm-dd") . '</label>';
    }
}