<?php

class sfArtWidgetFormInputJQueryDateTime extends sfWidgetForm
{

    /**
     * http://trentrichardson.com/examples/timepicker/
     * spora część opcji ukazanych na powyższej stronie jest dostępnych poprzez opcje konfiguracyjne
     * aby widget pokazywał sam czas, należy "date_format" ustawić na false
     * date_format i time_format są to formaty jquerowe, dokładny opis na powyższej stronie
     * w min_date i max_date należy przekazać daty w formacie phpowym;)
     */

    protected function configure($options = array(), $attributes = array())
    {
        $this->addOption('culture', BaseForm::getContext()->getUser()->getCulture());
        $this->addOption('date_format', 'yy-mm-dd');
        $this->addOption('time_format', 'hh:mm');
        $this->addOption('with_seconds', false);
        $this->addOption('step_hour', 1);
        $this->addOption('step_minute', 1);
        $this->addOption('step_second', 1);
        $this->addOption('hour_min', false);
        $this->addOption('hour_max', false);
        $this->addOption('number_of_months', 1);
        $this->addOption('min_date', false);
        $this->addOption('max_date', false);

        parent::configure($options, $attributes);
    }

    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $id = $this->generateId($name);
        $valueDateFormat = "Y-m-d H:i";

        $js = $this->getJavascript($id, $valueDateFormat);

        $attributes = array_merge(
            array(
                'class' => isset($attributes['class']) ? $attributes['class'] . ' hasDatetimepicker' : 'hasDatetimepicker',
                'type' => 'text',
                'size' => strlen($valueDateFormat) + 3,
                'id' => $id,
                'name' => $name,
                'value' => (is_null($value) || $value == '') ? '' : date($valueDateFormat, strtotime($value)),
            ), $attributes);

        return '<div class="art_input"> ' . artBox::beginBox('horizontal') . $this->renderTag('input', $attributes) . artBox::endBox('horizontal') . '</div>' . $js;
    }

    public function getJavascript($id, &$valueDateFormat)
    {
        $culture = $this->getOption('culture');
        $dateFormat = $this->getOption('date_format');
        $timeFormat = $this->getOption('time_format');
        $withSeconds = $this->getOption('with_seconds');
        $withMiliseconds = $this->getOption('with_miliseconds');
        $stepHour = $this->getOption('step_hour');
        $stepMinute = $this->getOption('step_minute');
        $stepSecond = $this->getOption('step_second');
        $hourMin = $this->getOption('hour_min');
        $hourMax = $this->getOption('hour_max');
        $numberOfMonths = $this->getOption('number_of_months');
        $minDate = $this->getOption('min_date');
        $maxDate = $this->getOption('max_date');

        $js = "<script type=\"text/javascript\">
          $(function() {";

        if ($dateFormat)
            $js .= "$( \"#$id\" ).datetimepicker({
          dateFormat: '$dateFormat', \n";
        else {
            $js .= "$( \"#$id\" ).timepicker({
          dateFormat: '$dateFormat', \n";
            $valueDateFormat = "H:i";
        }

        if ($withSeconds) {
            if (strpos('ss', $timeFormat) === false)
                $timeFormat .= ':ss';

            $js .= "showSecond: true, \n";
            $valueDateFormat .= ":s";
        }

        if ($stepHour != 1)
            $js .= "stepHour: '$stepHour', \n";
        if ($stepMinute != 1)
            $js .= "stepMinute: '$stepMinute', \n";
        if ($stepSecond != 1)
            $js .= "stepSecond: '$stepSecond', \n";

        if ($hourMin)
            $js .= "hourMin: $hourMin,";
        if ($hourMax)
            $js .= "hourMax: $hourMax,";

        if ($minDate) {
            $date = date('Y, m, d, h, m', strtotime($minDate));
            $js .= "minDate: new Date($date),";
        }
        if ($maxDate) {
            $date = date('Y, m, d, h, m', strtotime($maxDate));
            $js .= "maxDate: new Date($date),";
        }


        $js .= "regional: '$culture',
          timeFormat: '$timeFormat',
          numberOfMonths: $numberOfMonths
        });
        $.datepicker.setDefaults($.datepicker.regional['$culture']);
            });
      </script>";

        return $js;
    }
}