<?php

class sfArtWidgetFormInputJQueryDateTimeRange extends sfWidgetForm
{
    protected function configure($options = array(), $attributes = array())
    {
        $this->addOption('culture', BaseForm::getContext()->getUser()->getCulture());
        $this->addOption('min_date', artDate::getYearBefore(1));
        $this->addOption('max_date', artDate::getYearAfter(1));

        $this->addOption('date_from', new sfArtWidgetFormInputJQueryDateTime($options));
        $this->addOption('date_to', new sfArtWidgetFormInputJQueryDateTime($options));

        parent::configure($options, $attributes);
    }


    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $attributes = array('size' => 27);

        return $this->getOption('date_from')->render($name . '[from]', $value['from'], $attributes, $errors) .
            '' . $this->getOption('date_to')->render($name . '[to]', $value['to'], $attributes, $errors) .
            '<br /><br /><label class="filter_hint">' . __("Date format: yyyy-mm-dd") . '</label>';
    }
}