<?php

/**
 * sfArtWidgetFormInput represents an HTML input tag, with rounded corners div's
 *
 */
class sfArtWidgetFormInputTextAutocomplete extends sfArtWidgetFormInputText
{
    public $withPlus;
    public $popupForm;
    public $urlPath;
    public $delay;
    public $minLength;
    public $hintLimit;
    public $dualInput;
    public $fieldToSet;

    public function configure($options = array(), $attributes = array())
    {
        parent::configure($options, $attributes);

        $this->addOption('class_out_box', false);
        $this->addOption('url_path', '');
        $this->addOption('min_length', '1');
        $this->addOption('delay', '300');
        $this->addOption('hint_limit', '10');
        $this->addOption('field_to_set', '');
        $this->addOption('dual_input', false);
        $this->addOption('with_plus', false);
        $this->addOption('popup_form', false);
        $this->addOption('autopick', true);
    }

    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $this->urlPath = $this->getOption('url_path');
        $this->minLength = $this->getOption('min_length');
        $this->delay = $this->getOption('delay');
        $this->hintLimit = $this->getOption('hint_limit');
        $this->dualInput = $this->getOption('dual_input');
        $this->withPlus = $this->getOption('with_plus');
        $this->fieldToSet = $this->getOption('field_to_set');
        $this->popupForm = $this->getOption('popup_form');

        $popupTitle = __('add_widget_' . $this->popupForm);
        $buttonCancel = __('Anuluj');
        $buttonOk = __('Dodaj');

        $js = '<script type="text/javascript">
      $(document).ready(function() {
        $("#addWidgetPopup' . $this->popupForm . '").click(function () { 
        var inputToUpdate = $(this).parent().parent().find(".toComplete").find("input").attr("id");
                  
        $.ajax({
            url:"' . url_for('@get_plus_widget_popup_form?form_to_use=' . $this->popupForm) . '&inputCaller="+inputToUpdate,
            dataType: "html",
            success: function(html) {

            if(document.getElementById("add-widget-popup"))
              document.getElementById("add-widget-popup").innerHTML = "";
          else
            $("body").append(\'<div id="add-widget-popup"></div>\');

          document.getElementById("add-widget-popup").innerHTML = html;
          $("#add-widget-popup").dialog({
              title: "' . $popupTitle . '" ,
              modal:true,
              width: \'auto\',
              close: function(event, ui){
                $(this).dialog("destroy");
              },
              buttons: { 
                  "' . $buttonCancel . '": function() { $(this).dialog("close"); },
                  "' . $buttonOk . '": function() { $("#add-widget-popup").find("form").submit();}
                } 
            });
          }
        });

        return false;
      });
        
        $( ".toComplete.autocomplete-' . $this->urlPath . '" ).find("input").autocomplete({
            source: function(request, response){
                                    getSource(request, response);
                          },
            minLength: ' . $this->minLength . ',
            delay: ' . $this->delay . ',
            select: function(event, ui) {
                                    $(".autocomplete-' . $this->urlPath . '.real-one").find("input").val(ui.item.id);
                                    $(".ui-autocomplete").find("li").remove();
                                    itemSelected=true;
			},
            close: function( event, ui ) {';

        if ($this->getOption('autopick'))
            $js .= 'if(!itemSelected){
        $(".autocomplete-' . $this->urlPath . '.real-one").find("input").val(singleHintId' . $this->urlPath . ');
        $(".toComplete.autocomplete-' . $this->urlPath . '").find("input").val($(".ui-autocomplete").find("a:first").html());
      }';

        $js .= '$(".ui-autocomplete").find("li").remove();
                                    itemSelected=false;
                            }
        });
    });
    
    var singleHintId' . $this->urlPath . ';
    var itemSelected = false; //flaga do pomocy przy obsludze wyboru lub nie z selecta
  
    $(".dual").keydown(function(event) {
    //czyszczenie ukrytego inputa zawierajacego ID po kazdej zmianie w szukajce (poza wcisnieciem entera)
        if (event.keyCode != "13") {
           $(".autocomplete-' . $this->urlPath . '.real-one").find("input").val("");
         }
         
     //gdy wcisniety enter oraz slowo wpisane w szukajke odpowiada konkretnemu wynikowi w podpowiedziach    
         else if (event.keyCode == "13" && $(".ui-autocomplete").find("li").length==1 && $(".ui-autocomplete").find("a").html().toLowerCase() == $(".dual").val().toLowerCase() ){
            $(".autocomplete-' . $this->urlPath . '.real-one").find("input").val(singleHintId' . $this->urlPath . ');
        }
    });

    function getSource(request, response){
      $.ajax({
          url:"' . url_for('@' . $this->urlPath) . '?pattern="+request.term+"&hint_limit=' . $this->hintLimit . '",
          dataType: "json",
          success: function( json ) {
            if (!json.hasOwnProperty(\'id\'))
              response( new Object());
            else
            {
              singleHintId' . $this->urlPath . '=json.id[0];
              response( $.map( json.hints, function(item) {
                  return {
                      label: item,
                      value: item,
                      id: json.id[jQuery.inArray(item, json.hints)]
                  }
              }));
            }
          }
        });
      }
    </script>';

        if ($this->withPlus)
            $plus = '<span class="widgetPlus widgetPlus-' . $this->urlPath . '"><a href="#" id="addWidgetPopup' . $this->popupForm . '"></a></span>';
        else
            $plus = '';

        if (!$this->dualInput)
            return '<span class="toComplete autocomplete-box autocomplete-' . $this->urlPath . '">'
                . parent::render($name, $value, $attributes, $errors)
                . '</span>' . $plus . $js;
        else {
            $this->setOption('type', 'hidden');

            return '<span class="real-one autocomplete-box autocomplete-' . $this->urlPath . '">'
                . parent::render($name, $value, $attributes, $errors)
                . '</span>
                <span class="toComplete autocomplete-' . $this->urlPath . '">
                  <input id="toComplete' . $this->urlPath . '" class="dual autocomplete-' . $this->urlPath . '" value="" />
                </span>' . $plus . $js;
        }
    }

    public function setLabel($value)
    {
        artWidgetHelper::setLabel($this, $value);
    }
}