<?php
/**
 * Description of sfArtWidgetFormInputTextWithCustomText
 *
 
 *
 */
class sfArtWidgetFormInputTextWithCustomText extends sfWidgetFormInputText
{

    public function configure($options = array(), $attributes = array())
    {
        parent::configure($options, $attributes);

        $this->addOption('class_out_box', false);
        $this->addRequiredOption('custom_text');
    }

    /**
     * @param  string $name        The element name
     * @param  string $value       The value displayed in this widget
     * @param  array  $attributes  An array of HTML attributes to be merged with the default HTML attributes
     * @param  array  $errors      An array of errors for the field
     *
     * @return string An HTML tag string
     *
     * @see sfWidgetFormInput
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $c = $this->getOption('class_out_box') ? $this->getOption('class_out_box') : '';

        return '<div class="art_input ' . $c . '">' .
            artBox::beginBox('horizontal') .
            parent::render($name, $value, $attributes, $errors) .
            artBox::endBox('horizontal') .
            '<span class="art-custom-input-text">' . $this->getOption('custom_text') . '</span>' .
            '</div>';
    }

}