<?php

class sfArtWidgetFormIntervalFilterInput extends sfWidgetForm
{

  protected function configure($options = array(), $attributes = array())
  {
    $this->addOption('with_empty', true);
    $this->addOption('hint_label1', 'a: - wartości większe niż a');
    $this->addOption('hint_label2', ':b - values less than b');
    $this->addOption('hint_label3', 'a:b - wartości pomiędzy a i b');
    $this->addOption('hint_label4', 'x|y - wartości w przedziałach x lub y');
    $this->addOption('template', '%input%<br />%hint_label1%<br />%hint_label2%<br />%hint_label3%<br />%hint_label4%');
  }

  public function render($name, $value = null, $attributes = array(), $errors = array())
  {
    $values = array_merge(array('text' => '', 'is_empty' => false), is_array($value) ? $value : array());

    return strtr($this->getOption('template'), array(
        '%input%' =>
          '<span class="input-container art-right">' . artBox::beginBox('horizontal_span')
          . $this->renderTag('input', array_merge(array('type' => 'text', 'id' => $this->generateId($name), 'name' => $name . '[text]', 'value' => $values['text']), $attributes))
          . artBox::endBox('horizontal_span') . '</span>',
        '%hint_label1%' => $this->getOption('with_empty') ? $this->renderContentTag('label', $this->translate($this->getOption('hint_label1')), array('for' => $this->generateId($name . '[is_empty]'))) : '',
        '%hint_label2%' => $this->getOption('with_empty') ? $this->renderContentTag('label', $this->translate($this->getOption('hint_label2')), array('for' => $this->generateId($name . '[is_empty]'))) : '',
        '%hint_label3%' => $this->getOption('with_empty') ? $this->renderContentTag('label', $this->translate($this->getOption('hint_label3')), array('for' => $this->generateId($name . '[is_empty]'))) : '',
        '%hint_label4%' => $this->getOption('with_empty') ? $this->renderContentTag('label', $this->translate($this->getOption('hint_label4')), array('for' => $this->generateId($name . '[is_empty]'))) : '',
    ));
  }

  public static function addColumnQuery(Doctrine_Query $query, $field, $values)
  {
    $rootAlias = $query->getRootAlias();
    $question = '';
    if (!is_array($values))
      $values = array($values);

    if (!count($values))
      return;
    $price = $values['text'];
    $type = "AND";
    
    if (substr_count($price, '|') == 0)
      self::countInterval($query, $question, $price, $type, $field);
    else
    { 
      $tab = explode('|', $price);
      foreach ($tab as $element)
      {
        if (!empty($element))
        {
          self::countInterval($query, $question, $element, $type, $field);
          if ($type == "AND")
            $type = "OR";
        }
      }
    }
    if(strlen($question) > 0)
    {
      $question = substr ($question, 5);
      $question = '(' . $question . ')';
      return $query->andWhere($question);
    }
    else
      return $query;
  }

  public static function countInterval(Doctrine_Query $query, &$question, $price, $type, $field)
  {
    $rootAlias = $query->getRootAlias();
    if (strpos($price, ':') !== false)
    {
      $tab = explode(':', $price);
      if (count($tab) == 2)
      {
        if ((is_numeric($tab[0]) && is_numeric($tab[1])))
          $question = $question . ' ' . $type . ' ' . $rootAlias . '.' . $field . ' BETWEEN ' . trim($tab[0]) . ' AND ' . trim($tab[1]);
        else if (is_numeric($tab[0]) && (!is_numeric($tab[1])))
          $question = $question . ' ' . $type . ' ' . $rootAlias . '.' . $field . ' > ' . trim($tab[0]);
        else if ((!is_numeric($tab[0])) && (is_numeric($tab[1])))
          $question = $question . ' ' . $type . ' ' . $rootAlias . '.' . $field . ' < ' . trim($tab[1]);
      }
    }

    if (is_numeric($price))
      $question = $question . ' ' . $type . ' ' . $rootAlias . '.' . $field . ' = ' . $price;
    return $question;
  }

}