<?php

class sfArtWidgetFormJQueryDateRange extends sfWidgetForm
{
    protected function configure($options = array(), $attributes = array())
    {
        $this->addOption('image', false);
        $this->addOption('config', '{}');
        $this->addOption('culture', '');
        $this->addOption('date_from', new sfWidgetFormDate());
        $this->addOption('date_to', new sfWidgetFormDate());

        parent::configure($options, $attributes);

        if ('en' == $this->getOption('culture')) {
            $this->setOption('culture', 'en');
        } else {
            $this->setOption('culture', 'pl');
        }
    }


    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $prefix = str_replace('-', '_', $this->generateId($name));

        $image = '';
        if (false !== $this->getOption('image')) {
            $image = sprintf(', buttonImage: "%s", buttonImageOnly: true', $this->getOption('image'));
        }

        if ($this->getOption('date_from') instanceof sfWidgetFormDateTime) {
            $years = $this->getOption('date_from')->getDateWidget()->getOption('years');
        } else {
            $years = $this->getOption('date_from')->getOption('years');
        }

        if (false !== $this->getOption('image')) {
            $image = sprintf(', buttonImage: "%s", buttonImageOnly: true', $this->getOption('image'));
        }

        if ($this->getOption('date_to') instanceof sfWidgetFormDateTime) {
            $years = $this->getOption('date_to')->getDateWidget()->getOption('years');
        } else {
            $years = $this->getOption('date_to')->getOption('years');
        }

        $temp = $name;
        $name = $temp . '[from]';
        $name2 = $temp . '[to]';

        return $this->getOption('date_from')->render($name, $value, $attributes, $errors) .
            $this->renderTag('input', array('type' => 'hidden', 'size' => 10, 'id' => $id = $this->generateId($name) . '_jquery_control', 'disabled' => 'disabled')) .
            sprintf(<<<EOF
<script type="text/javascript">
  function wfd_%s_read_linked()
  {
    jQuery("#%s").val(jQuery("#%s").val() + "-" + jQuery("#%s").val() + "-" + jQuery("#%s").val());
    return {};
  }

  function wfd_%s_update_linked(date)
  {
    jQuery("#%s").val(parseInt(date.substring(0, 4), 10));
    jQuery("#%s").val(parseInt(date.substring(5, 7), 10));
    jQuery("#%s").val(parseInt(date.substring(8), 10));

    wfd_%s_check_linked_days();
  }

  function wfd_%s_check_linked_days()
  {
    var daysInMonth = 32 - new Date(jQuery("#%s").val(), jQuery("#%s").val() - 1, 32).getDate();

    jQuery("#%s option").attr("enable", "");
    jQuery("#%s option:gt(" + (%s) +")").attr("disable", "disable");

    if (jQuery("#%s").val() > daysInMonth)
    {
      jQuery("#%s").val(daysInMonth);
    }
  }

  jQuery(document).ready(function() {
    jQuery("#%s").datepicker(jQuery.extend({}, {
      minDate:    new Date(%s, 1 - 1, 1),
      maxDate:    new Date(%s, 12 - 1, 31),
      beforeShow: wfd_%s_read_linked,
      onSelect:   wfd_%s_update_linked,
      showOn:     "button"
      %s
    }, jQuery.datepicker.regional["%s"], %s, {dateFormat: "yy-mm-dd"}));
    wfd_%s_check_linked_days();
  });

  jQuery("#%s, #%s, #%s").change(wfd_%s_check_linked_days);
</script>
EOF
                ,
                $prefix, $id,
                $this->generateId($name . '[year]'), $this->generateId($name . '[month]'), $this->generateId($name . '[day]'),
                $prefix,
                $this->generateId($name . '[year]'), $this->generateId($name . '[month]'), $this->generateId($name . '[day]'),
                $prefix, $prefix,
                $this->generateId($name . '[year]'), $this->generateId($name . '[month]'),
                $this->generateId($name . '[day]'), $this->generateId($name . '[day]'),
                ($this->getOption('date_from')->getOption('can_be_empty') ? 'daysInMonth' : 'daysInMonth - 1'),
                $this->generateId($name . '[day]'), $this->generateId($name . '[day]'),
                $id,
                min($years), max($years),
                $prefix, $prefix, $image, $this->getOption('culture'), $this->getOption('config'),
                $prefix,
                $this->generateId($name . '[day]'), $this->generateId($name . '[month]'), $this->generateId($name . '[year]'),
                $prefix
            ) . '<br />' .
            $this->getOption('date_to')->render($name2, $value, $attributes, $errors) .
            $this->renderTag('input', array('type' => 'hidden', 'size' => 10, 'id' => $id = $this->generateId($name2) . '_jquery_control2', 'disabled' => 'disabled')) .
            sprintf(<<<EOF
<script type="text/javascript">
  function wfd_%s_read_linked2()
  {
    jQuery("#%s").val(jQuery("#%s").val() + "-" + jQuery("#%s").val() + "-" + jQuery("#%s").val());

    return {};
  }

  function wfd_%s_update_linked2(date)
  {
    jQuery("#%s").val(parseInt(date.substring(0, 4), 10));
    jQuery("#%s").val(parseInt(date.substring(5, 7), 10));
    jQuery("#%s").val(parseInt(date.substring(8), 10));

    wfd_%s_check_linked_days2();
  }

  function wfd_%s_check_linked_days2()
  {
    var daysInMonth = 32 - new Date(jQuery("#%s").val(), jQuery("#%s").val() - 1, 32).getDate();

    jQuery("#%s option").attr("enable", "");
    jQuery("#%s option:gt(" + (%s) +")").attr("disable", "disable");

    if (jQuery("#%s").val() > daysInMonth)
    {
      jQuery("#%s").val(daysInMonth);
    }
  }

  jQuery(document).ready(function() {
    jQuery("#%s").datepicker(jQuery.extend({}, {
      minDate:    new Date(%s, 1 - 1, 1),
      maxDate:    new Date(%s, 12 - 1, 31),
      beforeShow: wfd_%s_read_linked2,
      onSelect:   wfd_%s_update_linked2,
      showOn:     "button"
      %s
    }, jQuery.datepicker.regional["%s"], %s, {dateFormat: "yy-mm-dd"}));
    wfd_%s_check_linked_days2();
  });

  jQuery("#%s, #%s, #%s").change(wfd_%s_check_linked_days2);
</script>
EOF
                ,
                $prefix, $id,
                $this->generateId($name2 . '[year]'), $this->generateId($name2 . '[month]'), $this->generateId($name2 . '[day]'),
                $prefix,
                $this->generateId($name2 . '[year]'), $this->generateId($name2 . '[month]'), $this->generateId($name2 . '[day]'),
                $prefix, $prefix,
                $this->generateId($name2 . '[year]'), $this->generateId($name2 . '[month]'),
                $this->generateId($name2 . '[day]'), $this->generateId($name2 . '[day]'),
                ($this->getOption('date_to')->getOption('can_be_empty') ? 'daysInMonth' : 'daysInMonth - 1'),
                $this->generateId($name2 . '[day]'), $this->generateId($name2 . '[day]'),
                $id,
                min($years), max($years),
                $prefix, $prefix, $image, $this->getOption('culture'), $this->getOption('config'),
                $prefix,
                $this->generateId($name2 . '[day]'), $this->generateId($name2 . '[month]'), $this->generateId($name2 . '[year]'),
                $prefix);
    }

    public static function addDateQuery(Doctrine_Query $query, $field, $values)
    {
        $date_from = '';
        $date_to = '';
        $rootAlias = $query->getRootAlias();

        foreach ($values as $key => $value) {
            if ($key == "from" && strlen($value) >= 10)
                $date_from = $value;
            else if ($key == "to" && strlen($value) >= 10)
                $date_to = substr($value, 0, 10);
        }
        if (is_array($date_from)) {
            if ($date_from['year'] != '') {
                if (strlen($date_from['month']) == 1)
                    $date_from['month'] = '0' . $date_from['month'];
                if (strlen($date_from['day']) == 1)
                    $date_from['day'] = '0' . $date_from['day'];
                $date_from = $date_from['year'] . '-' . $date_from['month'] . '-' . $date_from['day'];
            } else
                $date_from = '';
        }
        if (is_array($date_to)) {
            if ($date_to['year'] != '') {
                if (strlen($date_to['month']) == 1)
                    $date_to['month'] = '0' . $date_to['month'];
                if (strlen($date_to['day']) == 1)
                    $date_to['day'] = '0' . $date_to['day'];
                $date_to = $date_to['year'] . '-' . $date_to['month'] . '-' . $date_to['day'];
            } else
                $date_to = '';
        }

        $question = '';
        if (!empty($date_from) && !empty($date_to))
            $question = $rootAlias . '.date BETWEEN ' . "'" . $date_from . "' AND '" . $date_to . "'";
        else if (empty($date_from) && !empty($date_to))
            $question = $rootAlias . ".date <= '" . $date_to . "'";
        else if (!empty($date_from) && empty($date_to))
            $question = $rootAlias . ".date >= '" . $date_from . "'";
        if (!empty($question)) {
            $question = '(' . $question . ')';
            return $query->andWhere($question);
        } else
            return $query;
    }
}