<?php

/*
 * sfArtWidgetFormJQuerySlider represents text input as slider with
 * fixed minimum (thers to do) check http://jqueryui.com/demos/slider/
 *
 * @package    symfony
 * @subpackage widget
 */

class sfArtWidgetFormJQuerySlider extends sfWidgetFormInputText
{

    protected function configure($options = array(), $attributes = array())
    {
        if (isset($options['min']))
            $this->addOption('min', $options['min']);
        if (isset($options['max']))
            $this->addOption('max', $options['max']);
        if (isset($options['value']))
            $this->addOption('value', $options['value']);

        $baseOptions = isset($options['min']) ? 'min:' . $options['min'] : 'min:' . sfConfig::get('app_jquery_slider_min');
        $baseOptions .= isset($options['max']) ? ',max:' . $options['max'] : ',max:' . sfConfig::get('app_jquery_slider_max');

        if (isset($options['value']))
            $baseOptions .= ',value:' . $options['value'];

        $this->addOption('config', $baseOptions);

        parent::configure($options, $attributes);
    }

    public function setLabel($value)
    {
        if ($this->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';
        $this->setOption('label', $value);

        return $this;
    }

    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        if (isset($attributes['class'])) {
            $attributes['class'] .= 'sliderAmountInput';
        } else {
            $attributes['class'] = 'sliderAmountInput';
        }


        return sprintf('
<div><div id="%s"></div>
<div class="sliderAmount"></div>
<script type="text/javascript">
  $(document).ready(function() {
    $("#%s").slider({
      %s ,range:"min",slide: function( event, ui ) {
				$( ".sliderAmount", $(this).parent() ).html(ui.value );
                $( ".sliderAmountInput", $(this).parent() ).val(ui.value );
			}
   });
$( ".sliderAmountInput", $("#%s").parent() ).val($("#%s").slider( "value" ) );
$( ".sliderAmount", $("#%s").parent() ).html($("#%s").slider( "value" ) );
 });
</script>
%s
</div>'
            , $this->generateId($name) . '-slider', $this->generateId($name) . '-slider', $this->getOption('config'), $this->generateId($name) . '-slider', $this->generateId($name) . '-slider', $this->generateId($name) . '-slider', $this->generateId($name) . '-slider', $this->renderTag('input', array_merge(array('type' => 'hidden', 'name' => $name), $attributes))
        );
    }

}
