<?php

/**
 */
class sfArtSelectImageWidget extends sfWidgetFormInput
{

    /**
     * @param array $options
     * @param array $attributes
     */
    public function configure($options = array(), $attributes = array())
    {
        parent::configure($options, $attributes);
        $this->setOption('type', 'hidden');
        $this->addOption('default_image', 'default.png');
        $this->addRequiredOption('images_dir'); // musi być z / na końcu
        $this->addOption('images_absolute_dir', false); //ścieżka bezględna w katalogu site/web
    }

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $id = $this->generateId($name);
        $imagesDir = $this->getOption('images_dir');
        $imagesAbsoluteDir = $this->getOption('images_absolute_dir') === false ? sfConfig::get('sf_web_dir') . $imagesDir : $this->getOption('images_absolute_dir');

        $value = is_null($value) ? $this->getOption('default_image') : $value;

        $activeid = '';

        $hiddenInput = parent::render($name, $value, $attributes, $errors);
        $images = '<div class="image-widget-images">';

        foreach (artFilePath::allNamesFromFolder($imagesAbsoluteDir, array('png', 'jpeg', 'jpg', 'ico'), false) as $i => $image) {
            $imageId = $id . '-' . $i;

            if ($value == $image)
                $activeId = $imageId;

            $images .= '<span id="' . $imageId . '" class="image-widget-single-image"><img src="' . $imagesDir . $image . '" alt="' . $image . '" onclick="selectImage(\'' . $imageId . '\')" /></span>';
        }

        $images .= '</div>';

        $jsFunction = '<script type="text/javascript">
      $(document).ready(function(){
        selectImage(\'' . $activeId . '\');
      });

      function selectImage(imageId){
        $("#' . $id . '").val($("#" + imageId + " img").attr("alt"));
        $(".image-widget-single-widget-active").each(function(){
          $(this).removeClass("image-widget-single-widget-active");
        });
        $("#" + imageId).addClass("image-widget-single-widget-active");
      }
    </script>';

        return $hiddenInput . $images . $jsFunction;
    }
}