<?php
class sfArtWidgetFormTemplateInsert extends sfWidgetForm
{

    /**
     * @param array $options
     * @param array $attributes
     */
    public function configure($options = array(), $attributes = array())
    {
        if (isset($options['templates']))
            $this->addOption('templates', $options['templates']);

        parent::configure($options, $attributes);
    }

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $textHtml = '<script>
                   $.fx.speeds._default = 1000;
                    $(function() {
                        $( ".dialog-add-template" ).dialog({
                            autoOpen: false,
                        });

                        $( "#open-template-dialog" ).click(function() {
                            $( ".dialog-add-template" ).dialog( "open" );
                            return false;
                        });
                        
                        $(".add-template").click(function() {
                            var $template = $(".items option:selected").attr("value");
                            var $pre_evaluator = $(".items option:selected").attr("name");
                            var $post_evaluator = $(".items option:selected").attr("alt");
                            $("#step_pre_evaluator").append($pre_evaluator);
                            $("#step_post_evaluator").append($post_evaluator);
                              editor = CKEDITOR.instances.step_pl_description;
                              editor.setData(editor.getData()+ $template);
                              editor = CKEDITOR.instances.step_en_description;
                              editor.setData(editor.getData()+ $template);
                            $("#cke_contents_step_pl_description iframe html body").append($template);
                         });
                    });
	                </script>';

        $textHtml .= '<div class="dialog-add-template" title="Wstaw szablon kroku:" style="display: none;">';

        $textHtml .= 'Wybierz szablon, który chcesz dodac: <select class="items">';
        foreach ($this->getOption('templates') as $key => $value) {
            $textHtml .= '<option value="' . htmlentities($value['description']) . '"
                                name="' . htmlentities($value['pre_evaluator']) . '"
                                alt="' . htmlentities($value['post_evaluator']) . '">' . $value['name'] . '</option>';
        }

        $textHtml .= '</select>';

        $textHtml .= '<button class="add-template">dodaj</button></div>';

        $textHtml .= '<button id="open-template-dialog">dodaj szablon kroku</button>';

        return $textHtml;
    }
}