<?php

class sfArtWidgetFormTexareaWithInserts extends sfWidgetFormTextarea
{
    private $functions = array();
    private $target;

    /**
     * @param array $options
     * @param array $attributes
     * @param array $functions
     * @param $target
     */
    function __construct($options = array(), $attributes = array(), $functions = array(), $target)
    {
        parent::__construct($options, $attributes);
        $this->functions = array_merge($this->functions, $functions);
        $this->target = $target;
    }

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {

        $textArea = parent::render($name, $value, $attributes, $errors);

        $textArea .= '<script>
                   $.fx.speeds._default = 1000;
                    $(function() {
                        $( "#dialog-' . $this->target . '" ).dialog({
                            autoOpen: false,
                        });

                        $( "#opener-' . $this->target . '" ).click(function() {
                            $( "#dialog-' . $this->target . '" ).dialog( "open" );
                            return false;
                        });
                    });
	                </script>';

        // okno popup z funkcjami do wybrania
        $textArea .= '<div id="dialog-' . $this->target . '" title="Dodawanie funkcji:" style="display: none;">';
        $textArea .= 'Wybierz funkcję, którą chcesz dodać: <select id="iteams-' . $this->target . '">';

        foreach ($this->functions as $key => $value)
            $textArea .= '<option value="' . $value . '">' . $key . '</option>';

        $textArea .= '</select>';
        $textArea .= '<button id="add-' . $this->target . '">dodaj</button></div>';

        // przycisk dodaj element
        $textArea .= '<div class="evaluator-actions"><button id="opener-' . $this->target . '">Dodaj funkcje</button>';
        $textArea .= '<button id="variable-for-' . $this->target . '" onclick="getElementPopup(\'' . $this->target . '\',\'all\'); return false;">Pobranie zmiennej</button></div>';

        $textArea .= '<script>
        $("#add-' . $this->target . '").click(function () {
              var str = $("#iteams-' . $this->target . ' option:selected").val();
              $("#' . $this->target . '").val($("#' . $this->target . '").val()+str);
            })
        </script>';


        return $textArea;
    }

}
