<?php

/**
 * sfJSPlugin konfiguracja.
 *
 * @package     sfJSPlugin
 * @subpackage  config
 * @version     0.1-DEV
 */
class sfAssetsPluginConfiguration extends sfPluginConfiguration {

  /**
   * @see sfPluginConfiguration
   */
  public function initialize() {
    // Jeśli app_djs_conf_toolbar (TRUE, jako opcja domyslna)

    if (sfConfig::get('sf_web_debug') && sfConfig::get('app_djs_conf_toolbar', true)) {
      // Dodaje nową pozycje do paska debugera

      $this->dispatcher->connect('debug.web.load_panels', array(
          'artWebDebugPanelDJS',
          'listenToLoadDebugWebPanelEvent'
      ));

      $this->dispatcher->connect('debug.web.load_panels', array(
          'artWebDebugPanelConfigWithDJS',
          'listenToLoadDebugWebPanelEvent'
      ));
    }

    if (sfConfig::get('sf_web_debug') && sfConfig::get('app_sf_js_plugin_toolbar', true)) {
      // Dodaje nową pozycje do paska debugera

      $this->dispatcher->connect('debug.web.load_panels', array(
          'sfWebDebugPanelJS',
          'listenToLoadDebugWebPanelEvent'
      ));
    }

    if (sfConfig::get('app_sf_assets_plugin_enabled', false)) {
      $this->dispatcher->connect('context.load_factories', array($this, 'listenToContextLoadFactoriesEvent'));
    }

    sfConfig::set('sf_standard_helpers', array_merge(sfConfig::get('sf_standard_helpers', array()), array('sfJSOptimizer')));


    $this->dispatcher->connect('routing.load_configuration', array($this, 'listenToRoutingLoadConfigurationEvent'));
    $this->dispatcher->connect('context.load_factories', array($this, 'listenToLoadFactoriesEvent'));
  }

  /**
   * Dołączenie assets_optimizer do kontextu.
   *
   * @param  sfEvent
   */
  public function listenToContextLoadFactoriesEvent(sfEvent $event) {
    $context = $event->getSubject();

    if (!class_exists($serviceClass = sfConfig::get('app_sf_assets_plugin_class', 'sfAssetsOptimizerService'))) {
      throw new sfConfigurationException(sprintf('The %s service class does not exist', $serviceClass));
    }

    $configuration = sfConfig::get('app_sf_assets_plugin_configuration', array());

    $viewArray = sfViewConfigHandler::getConfiguration(array(sfConfig::get('sf_app_dir') . '/config/view.yml'));

    $configuration['javascript']['params']['files'] = $viewArray['all']['optimizer_javascript_files'];
    $configuration['stylesheet']['params']['files'] = $viewArray['all']['optimizer_stylesheet_files'];

    $assetsOptimizer = new $serviceClass($context->getEventDispatcher(), $configuration);

    $context->set('assets_optimizer', $assetsOptimizer);
  }

  /**
   * Podłączenie do eventa. Dołączenie nowego routingu do tablicy routingów.
   *
   * @return void
   * */
  public function listenToRoutingLoadConfigurationEvent(sfEvent $event) {

    // Sprawdź czy włączony jest moduł w setting oraz opcję w app.
    if (in_array('sfJSRouting', sfConfig::get('sf_enabled_modules')) && sfConfig::get('app_sf_assets_plugin_routing_register_routes', true)) {

      $djsRoute = new sfRequestRoute(
              '/js/app/djs.djs', array('sf_format' => 'js', 'time' => time(), 'module' => 'sfJSDynamics', 'action' => 'dynamicJavascripts'), array('format' => array('js'), 'method' => array('GET')), array()
      );

      $event->getSubject()->prependRoute('sf_assets_plugin_djs', $djsRoute);
    }
  }

  /**
   * Podłączenie do eventa. Dołączenie plików JavaScript.
   *
   * @return void
   * */
  public function listenToLoadFactoriesEvent(sfEvent $event) {

    // Sprawdź czy włączony jest moduł w setting oraz opcję w app.
    if (in_array('sfJSRouting', sfConfig::get('sf_enabled_modules')) && sfConfig::get('app_sf_assets_plugin_register_scripts', true)) {

      $response = $event->getSubject()->getResponse();
      $routing = $event->getSubject()->getRouting();

      // Dołączenie JS do response.

      $response->addJavascript($routing->generate('sf_assets_plugin_djs'), sfWebResponse::LAST);
    }
  }

}
