<?php

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * sfDebug provides some method to help debugging a symfony application.
 *
 * @package    symfony
 * @subpackage debug
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfDebug.class.php 31250 2010-10-26 14:18:26Z fabien $
 */
class artDebugWithDJS extends sfDebug {

    /**
     * Returns response parameters as an array.
     *
     * @param sfResponse $response A sfResponse instance
     *
     * @return array The response parameters
     */
    public static function responseAsArray(sfResponse $response = null) {

        if (!$response) {
            return array();
        }

        return array(
            'status' => array('code' => $response->getStatusCode(), 'text' => $response->getStatusText()),
            'options' => $response->getOptions(),
            'cookies' => method_exists($response, 'getCookies') ? $response->getCookies() : array(),
            'httpHeaders' => method_exists($response, 'getHttpHeaders') ? $response->getHttpHeaders() : array(),
            'javascripts' => method_exists($response, 'getJavascripts') ? $response->getJavascripts('ALL') : array(),
            'dynamic_javascripts' => method_exists($response, 'getDynamicJavascripts') ? $response->getDynamicJavascripts() : array(),
            'stylesheets' => method_exists($response, 'getStylesheets') ? $response->getStylesheets('ALL') : array(),
            'metas' => method_exists($response, 'getMetas') ? $response->getMetas() : array(),
            'httpMetas' => method_exists($response, 'getHttpMetas') ? $response->getHttpMetas() : array(),
        );
    }

}
