<?php
/**
 * Dynamiczne javascripty w pasku debugera i w response.
 *
 * @package    artCMSPlugin
 * @subpackage debug

 * @version    1.0.0
 */

class artWebDebugPanelConfigWithDJS extends sfWebDebugPanelConfig
{
  /**
   * Pobranie zdarzenia LoadDebugWebPanel & dodawanie do panelu.
   *
   * @param   sfEvent $event
   */
  public static function listenToLoadDebugWebPanelEvent(sfEvent $event)
  {
    if (sfConfig::get('sf_logging_enabled')) {
      // Odrazu zastapi stary panel config
      $event->getSubject()->setPanel(
        'config',
        new self($event->getSubject())
      );
    }
  }

  public function getPanelContent()
  {
    $config = array(
      'debug'        => sfConfig::get('sf_debug')           ? 'on' : 'off',
      'xdebug'       => extension_loaded('xdebug')          ? 'on' : 'off',
      'logging'      => sfConfig::get('sf_logging_enabled') ? 'on' : 'off',
      'cache'        => sfConfig::get('sf_cache')           ? 'on' : 'off',
      'compression'  => sfConfig::get('sf_compressed')      ? 'on' : 'off',
      'tokenizer'    => function_exists('token_get_all')    ? 'on' : 'off',
      'eaccelerator' => extension_loaded('eaccelerator') && ini_get('eaccelerator.enable') ? 'on' : 'off',
      'apc'          => extension_loaded('apc') && ini_get('apc.enabled')                  ? 'on' : 'off',
      'xcache'       => extension_loaded('xcache') && ini_get('xcache.cacher')             ? 'on' : 'off',
    );

    $html = '<ul id="sfWebDebugConfigSummary">';
    foreach ($config as $key => $value)
    {
      $html .= '<li class="is'.$value.($key == 'xcache' ? ' last' : '').'">'.$key.'</li>';
    }
    $html .= '</ul>';

    $context = sfContext::getInstance();
    $html .= $this->formatArrayAsHtml('request',  artDebugWithDJS::requestAsArray($context->getRequest()));
    $html .= $this->formatArrayAsHtml('response', artDebugWithDJS::responseAsArray($context->getResponse()));
    $html .= $this->formatArrayAsHtml('user',     artDebugWithDJS::userAsArray($context->getUser()));
    $html .= $this->formatArrayAsHtml('settings', artDebugWithDJS::settingsAsArray());
    $html .= $this->formatArrayAsHtml('globals',  artDebugWithDJS::globalsAsArray());
    $html .= $this->formatArrayAsHtml('php',      artDebugWithDJS::phpInfoAsArray());
    $html .= $this->formatArrayAsHtml('symfony',  artDebugWithDJS::symfonyInfoAsArray());

    return $html;
  }
}
