<?php
/**
 * Dynamiczne javascripty w pasku debugera.
 *
 * @package    artCMSPlugin
 * @subpackage debug

 * @version    1.0.0
 */

class artWebDebugPanelDJS extends sfWebDebugPanel
{

  /**
   * Błędy podczas dodawania dynamicznych javascriptów.
   */
  protected $errors = false;

  /**
   * Błędy podczas dodawania dynamicznych javascriptów.
   */
  protected $status = false;

  /**
   * Konfiguracja.
   */
  protected $config = array();

  /**
   * Pobranie zdarzenia LoadDebugWebPanel & dodawanie do panelu.
   *
   * @param   sfEvent $event
   */
  public static function listenToLoadDebugWebPanelEvent(sfEvent $event)
  {
    $event->getSubject()->setPanel(
      'dynamic_javascripts',
      new self($event->getSubject())
    );
  }

  /**
   * Zwraca HTML w pasku tytułowym.
   */
  public function getTitle()
  {
    $path = sfContext::getInstance()->getRequest()->getRelativeUrlRoot();
    return '<img src="' . $path . '/sf/sf_admin/images/reset.png" alt="" height="16" width="16" /> djs';
  }

  /**
   * Zwraca tytuł.
   */
  public function getPanelTitle()
  {
    return 'Dynamiczne javascripty';
  }

  /**
   * @see sfWebDebugPanel
   */
  public function getPanelContent()
  {
    $panel = $this->getConfigurationContent() . '<table class="sfWebDebugLogs mb20 w100 fl">
    <tr>
      <th>Moduł</th>
      <th>Partial</th>
      <th>Dostępność pliku</th>
      <th style="text-align:center;">Status</th>
    </tr>';
    
    // AW: Dodalem bo zle sie bledy wyswietlaly jak akcja nie miala widoku (brak pliku *Success)
    $configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
    $context = sfContext::createInstance($configuration);
    $configuration->loadHelpers('ArteneoPartial');

    $modules = sfContext::getInstance()->getResponse()->getDynamicJavascripts();

    if (count($modules) > 0) {
      foreach ($modules as $module) {

        $info = array();
        $partial = get_partial_if_exists($module . '/dynamic_javascripts.js');

        if (($partial != false) || ($module == 'frontendManagement')) {
          $info['availability'] = 'dostępny';
          $info['error'] = 'green';
          $info['status'] = 'dołączony';
        }
        else {
          $info['availability'] = 'brak pliku';
          $info['status'] = 'nie dołączony';
          $info['error'] = 'red';
          $this->errors = true;
        }

        $info['module'] = $module;
        $info['partial'] = '_dynamic_javascripts.js.php';

        $panel .= $this->getInfoContent($info);
      }

      $panel .= '</table></br>';
    } else {
      $panel = '<span class="m20 ml0"><h2><i>Brak danych, Jeżeli podjełeś probę dodawanie dyniamicznych javascriptów, sprawdź konfigurację w app.</i></h2></span>';
    }

    $this->setStatus($this->errors ? sfLogger::ERR : ($this->status ? sfLogger::WARNING : sfLogger::INFO));

    return $panel;
  }

  /**
   * Zwraca informacje konfiguracyjne do LESS compiler.
   *
   * @return  string
   */
  protected function getConfigurationContent()
  {
    $debugInfo = '<dl id="djs_app" style="display: none;">';

    $this->config = sfConfig::get('app_djs_conf', array());

    foreach ($this->config as $name => $value) {
      if ($value == '1') {
        $value = 'włączony';
      } else {
        $value = 'wyłączony';
      }

      $debugInfo .= sprintf('<dt style="float:left; width: 100px"><strong>%s:</strong></dt>
      <dd>%s</dd>', $name, $value);
    }
    $debugInfo .= '</dl>';

    return sprintf(<<<EOF
      <h2>Konfiguracja djs view.yml %s</h2>
      %s<br/>
EOF
      , $this->getToggler('djs_app', 'Toggle configure info')
      , $debugInfo
    );
  }

  /**
   * Zwraca informacje o dołączanych partialach.
   *
   * @param   array   $info info of compilation process
   * @return  string
   */
  protected function getInfoContent($info, $error = false)
  {
    // Tworzy element w tabelce dla każdgo z plików.

    $infoRows = sprintf(<<<EOF
      <tr class="%s">
        <td class="sfWebDebugLogType">%s</td>
        <td class="sfWebDebugLogType">%s</td>
        <td class="sfWebDebugLogType">%s</td>
        <td class="sfWebDebugLogType bold" style="text-align:center;">%s</td>
      </tr>
EOF
      , $info['error']
      , $info['module']
      , $info['partial']
      , $info['availability']
      , $info['status']
    );

    return $infoRows;
  }
}
