<?php

class sfWebDebugPanelJS extends sfWebDebugPanel
{

  /**
   * Konfiguracja.
   */
  protected $config;

  /**
   * Pobranie zdarzenia LoadDebugWebPanel & dodawanie do panelu.
   *
   * @param   sfEvent $event
   */
  public static function listenToLoadDebugWebPanelEvent(sfEvent $event)
  {
    $event->getSubject()->setPanel(
      'javascript',
      new self($event->getSubject())
    );
  }

  /**
   * Zwraca HTML w pasku tytułowym.
   */
  public function getTitle()
  {
    $path = sfContext::getInstance()->getRequest()->getRelativeUrlRoot();
  	return '<img src="'.$path.'/images/js.png" alt="" height="20" width="20" /> sfJSPlugin';
  }

  /**
   * Zwraca tytuł.
   */
  public function getPanelTitle()
  {
    return 'sfJSPlugin - Jedno wielkie TODO ;)';
  }

  /**
   * @see sfWebDebugPanel
   */
  public function getPanelContent()
  {
//    $panel = $this->getConfigurationContent() . '<table class="sfWebDebugLogs mb20 w100 fl">
//    <tr>
//      <th>Kompilowany plik LESS</th>
//      <th>Wygenerowany plik CSS</th>
//      <th style="text-align:center;">Czas kompilacji (ms)</th>
//    </tr>';
//    $errorDescriptions = artLESS::getCompileErrors();
//    foreach (artLESS::getCompileResults() as $info)
//    {
//      $info['error'] = isset($errorDescriptions[$info['lessFile']]) ? $errorDescriptions[$info['lessFile']] : false;
//      $panel .= $this->getInfoContent($info);
//    }
//    $panel .= '</table></br>';

//    $this->setStatus($this->errors?sfLogger::ERR:($this->compiled?sfLogger::WARNING:sfLogger::INFO));

    return '<h2>Zrobić : <br/>
    <ul>
    <li>Zmienne konfiguracyjne</li>
    <li>Pokazać tłumaczony słownik</li>
    <li>Tabele routingu dostepną w JS</li>
    </ul></h2>';
  }

  /**
   * Zwraca informacje konfiguracyjne do LESS compiler.
   *
   * @return  string
   */
  protected function getConfigurationContent()
  {
    $debugInfo = '<dl id="less_debug" style="display: none;">';
    $this->config = artLESS::getConfig();
    foreach ($this->config->getDebugInfo() as $name => $value)
    {
      $debugInfo .= sprintf('<dt style="float:left; width: 100px"><strong>%s:</strong></dt>
      <dd>%s</dd>', $name, $value);
    }
    $debugInfo .= '</dl>';

    return sprintf(<<<EOF
      <h2>Konfiguracja LESS app.yml %s</h2>
      %s<br/>
EOF
      ,$this->getToggler('less_debug', 'Toggle debug info')
      ,$debugInfo
    );
  }

  /**
   * Zwraca informacje o kompilacji.
   *
   * @param   array   $info info of compilation process
   * @return  string
   */
  protected function getInfoContent($info, $error = false)
  {
    // Numer linii gdzie wystąpil błąd.
    $errorId = md5($info['lessFile']);

    // Link do pliku.
    $fileLink = $this->formatFileLink(
      $info['lessFile'], 1, str_replace($this->config->getLessPaths(), '', $info['lessFile'])
    );

    // Checking compile & error statuses
    if ($info['isCompiled'])
    {
      $this->compiled = true;
      $trStyle = 'background-color:#a1d18d;';
    }
    elseif ($info['error'])
    {
      $this->errors = true;
      $trStyle = 'background-color:#f18c89;';
      $fileLink .= ' ' . $this->getToggler('less_error_' . $errorId, 'Toggle error info');
    }
    else
    {
      $trStyle = '';
    }

    // Tworzy element w tabelce dla każdgo z plików.

    $infoRows = sprintf(<<<EOF
      <tr style="%s">
        <td class="sfWebDebugLogType">%s</td>
        <td class="sfWebDebugLogType bold">%s</td>
        <td class="sfWebDebugLogNumber" style="text-align:center;">%.2f</td>
      </tr>
      <tr id="less_error_%s" style="display:none;background-color:#f18c89;"><td style="padding-left:15px" colspan="2">%s<td></tr>
EOF
      ,$trStyle
      ,$fileLink
      ,str_replace($this->config->getCssPaths(), '', $info['cssFile'])
      ,($info['isCompiled'] ? $info['compTime'] * 1000 : 0)
      ,$errorId
      ,$info['error']
    );

    return $infoRows;
  }
}
