<?php
/**
 * sfJSPlugin Google Closure Compiler API - optymalizacja javascript.
 *
 * @package     sfJSPlugin
 * @subpackage  driver
 *
 * @see http://code.google.com/intl/en_US/closure/compiler/docs/api-ref.html
 */
class sfJSDriverGoogleClosureCompilerApi extends sfJSDriverBase
{
    const SERVICE_URL = 'http://closure-compiler.appspot.com/compile';

    /**
     * Tworzy nowy plik.
     *
     * @param $file
     * @param bool $replace
     * @return mixed
     * @throws RuntimeException
     */
    public function doProcessFile($file, $replace = false)
    {
        if (!function_exists('curl_init')) {
            throw new RuntimeException('Brak wymaganego PHP CURL');
        }

        $content = file_get_contents($file);

        $ch = curl_init(self::SERVICE_URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, 'output_info=compiled_code&output_format=text&compilation_level=SIMPLE_OPTIMIZATIONS&js_code=' . urlencode($content));

        $optimizedContent = curl_exec($ch);

        curl_close($ch);

        if ($replace) {
            return parent::replaceFile($file, $optimizedContent);
        } else {
            return $optimizedContent;
        }
    }
}
