<?php
/**
 * Pngout PNG - optymalizacja plików PNG.
 *
 * @package     sfJSPlugin
 * @subpackage  driver
 */
class sfJSDriverAdvPNG extends sfJSDriverBase
{

    /**
     * Tworzy nowy plik.
     *
     * @param $file
     * @param bool $replace
     * @return mixed
     * @throws LogicException
     * @throws RuntimeException
     */
    public function doProcessFile($file, $replace = false)
    {
        if (false === $replace) {
            throw new LogicException('Optymalizacja PNG dostępna tylko dla zastępowania plików');
        }

        exec('which advpng', $output, $return);

        if (!count($output) || $return > 0) {
            throw new RuntimeException('Program advpng nie jest zainstalowany w twoim systemie operacyjnym.');
        }

        exec(sprintf('advpng -4 -z %s 2>/dev/null', escapeshellarg($file)), $output, $return);

        return $file;
    }
}