<?php
/**
 * Pngcrush PNG optymalizacja plików PNG.
 *
 * @package     sfJSPlugin.
 * @subpackage  driver
 */
class sfJSDriverPngCrush extends sfJSDriverBase
{

    /**
     * Optymalizacja z wykożystaniem pngcrush.
     *
     * @see sfJSDriverBase
     */
    public function doProcessFile($file, $replace = false)
    {
        if (false === $replace) {
            throw new LogicException('Optymalizacja PNG dostępna tylko dla zastępowania plików');
        }

        exec('which pngcrush', $output, $return);

        if (!count($output) || $return > 0) {
            throw new RuntimeException('Program pngcrush nie jest zainstalowany w twoim systemie operacyjnym.');
        }

        $tmpFile = sprintf('%s.tmp', $file);

        exec(sprintf('pngcrush %s %s 2>/dev/null', escapeshellarg($file), escapeshellarg($tmpFile)), $output, $return);

        if (file_exists($tmpFile) && filesize($tmpFile) > filesize($file)) {
            copy($tmpFile, $file);
        }

        unlink($tmpFile);

        return $file;
    }
}