<?php
/**
 * Pngout PNG - optymalizacja plików PNG.
 *
 * @package     sfJSPlugin.
 * @subpackage  driver
 *
 * @see http://www.jonof.id.au/pngout
 */
class sfJSDriverPngout extends sfJSDriverBase
{
    /**
     * Optymalizacja za pomocą PNGOut
     *
     * @see sfJSDriverBase
     */
    public function doProcessFile($file, $replace = false)
    {
        if (false === $replace) {
            throw new LogicException('Optymalizacja PNG dostępna tylko dla zastępowania plików');
        }

        exec('which pngout', $output, $return);

        if (!count($output) || $return > 0) {
            throw new RuntimeException('Program pngout nie jest zainstalowany w twoim systemie operacyjnym.');
        }

        exec(sprintf('pngout %s 2>/dev/null', escapeshellarg($file)), $output, $return);

        return $file;
    }
}