<?php
/**
 * Cssmin - optymalizacja plików CSS.
 *
 * @package     sfJSPLugin
 * @subpackage  driver
 */

class sfJSDriverCssmin extends sfJSDriverBase
{
    /**
     * Optymalizacja plików CSS.
     * @param $file
     * @param bool $replace
     * @return mixed|string
     */
    public function doProcessFile($file, $replace = false)
    {
        $optimizedContent = cssmin::minify(file_get_contents($file));

        if ($replace) {
            return parent::replaceFile($file, $optimizedContent);
        } else {
            return $optimizedContent;
        }
    }
}