<?php
/**
 * Minify CSS Compressor - optymalizacja plików CSS.
 *
 * @package     sfJSPlugin
 * @subpackage  driver
 *
 * @see http://minify.googlecode.com/svn/trunk/min/lib/Minify/CSS/Compressor.php
 */

class sfJSDriverMinifyCssCompressor extends sfJSDriverBase
{
    /**
     * ptymalizacja plików CSS
     *
     * @param $file
     * @param bool $replace
     * @return mixed|string
     */
    public function doProcessFile($file, $replace = false)
    {
        $optimizedContent = Minify_CSS_Compressor::process(file_get_contents($file));

        if ($replace) {
            return parent::replaceFile($file, $optimizedContent);
        } else {
            return $optimizedContent;
        }
    }
}