<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class sfAssetsFilter extends sfFilter {

  public function execute($filterChain) {

    $serviceConfiguration = sfConfig::get('app_sf_assets_plugin_configuration', array());

    $assetsOptimizer = new sfAssetsOptimizerService($this->getContext()->getInstance()->getEventDispatcher(), $serviceConfiguration);

    $types = $assetsOptimizer->getEnabledOptimizers();

    foreach ($types as $key => $type) {
      $service = $assetsOptimizer->getOptimizer($type);

      if (!is_null($service)) {

        $optymizedFile = $service->getBaseAssetsDir() . $service->getOptimizedFileWebPath();
        $baseFile = $service->getBaseAssetsDir() . $service->getDestinationBase();


        if (!(is_file($baseFile) && is_file($optymizedFile))) {

          if (sfConfig::get('app_art_less_plugin_compile', false) && $type == 'stylesheet') {
            
            try {
              chdir(sfConfig::get('sf_root_dir'));
              $task = new lessCompileTask(sfContext::getInstance()->getEventDispatcher(), new sfFormatter());
              $task->run(array(), array());
              
            } catch (Exception $e) {
              throw new sfException("Wystąpił błąd podczas kompilacji LESS. ERROR: " . "\r\n" . $e);
            }
          }

          $app = sfContext::getInstance()->getConfiguration()->getApplication(); 
          
          try {
            chdir(sfConfig::get('sf_root_dir'));
            $task = new sfJSOptimizeAssetsTask(sfContext::getInstance()->getEventDispatcher(), new sfFormatter());
            $task->run(array('application' => $app), array());
          } catch (Exception $e) {
            throw new sfException("Wystąpił błąd podczas generowania plików JS/CSS. ERROR: " . "\r\n" . $e);
          }

          break;
        }
      }
    }

    $filterChain->execute($filterChain);
  }

}
