<?php

/**
 * Inkluduje pliki JS po optymalizacji.
 */
function include_optimized_javascripts() {
  $context = sfContext::getInstance();

  if ($context->has('assets_optimizer')) {
    $context->get('assets_optimizer')->replaceJavascripts($context->getResponse());
  }

  include_javascripts();
}

/**
 * Inkluduje pliki CSS po optymalizacji.
 */
function include_optimized_stylesheets() {
  $context = sfContext::getInstance();

  if ($context->has('assets_optimizer')) {
    $context->get('assets_optimizer')->replaceStylesheets($context->getResponse());
  }

  include_stylesheets();
}

/**
 * Inkluduje kod JS z komponentów partiali itp. Dołączonych w pluginach.
 */
function include_plugins() {

  include_component('google_api', 'getGoogleAnalyticsCode');

  include_partial('global/indicator');
}

/**
 * Inkluduje flashe. 
 */
function include_flashes() {

  if (has_slot('flashes')) {
    include_slot('flashes');
  } else {
    include_partial('artFlashes/flash_dialog', array('slot' => false, 'type' => 'notice'));
    include_partial('artFlashes/flash_dialog', array('slot' => false, 'type' => 'error'));
  }
}

/**
 * Dołącza pliki JS do Ckeditora. 
 */
function include_ie_js() {

  echo <<<EOF
    <!-- Internet Explorer FIX :D -->
    <!--[if lt IE 9]>
    <script type="text/javascript" src="/js/html5.js"></script>
    <link rel="stylesheet" href="/css/ie.css" type="text/css" media="all" />
    <![endif]-->
    <!--[if lt IE 8]>
    <div style=' clear: both; text-align:center; position: relative;'>
      <a href="http://windows.microsoft.com/en-US/internet-explorer/products/ie/home?ocid=ie6_countdown_bannercode">
        <img src="http://storage.ie6countdown.com/assets/100/images/banners/warning_bar_0000_us.jpg"
             border="0" height="42" width="820"
             alt="You are using an outdated browser. For a faster, safer browsing experience, upgrade for free today." />
      </a>
    </div>
    <![endif]-->
EOF;
}

/**
 * Dołącza pliki Ckeditora dla administratora. 
 */
function include_cke_js($user) {
  $response = sfContext::getInstance()->getResponse();
  
  if ($user->isAdmin()) {
    $response->addJavascript('/arteneo-theme/js/ckeditor/ckeditor.js', 'last');
  }
}