<?php
/**
 * Optymalizacja plików PNG.
 *
 * @package     sfJSPlugin
 * @subpackage  optimizer
 */

class sfJSOptimizerPngImage extends sfJSOptimizerBase
{
    /**
     * @see sfJSOptimizerBase
     */
    public function configure(array $configuration = array())
    {
        parent::configure($configuration);

        if (isset($configuration['files'])) {
            parent::setFiles($configuration['files']);
        } else if (isset($configuration['folders'])) {
            parent::setFiles($this->findPngImages($configuration['folders']));
        } else {
            throw new sfConfigurationException('Musisz zdefiniować opcje "files" lub "folders" w pliku app.yml');
        }
        $this->replaceFiles = true;
    }

    /**
     * Znajduje pliki PNG/
     *
     * @param  array
     * @return array
     */
    public function findPngImages(array $folders = array())
    {
        $files = array();

        foreach ($folders as $folder) {
            if (!is_dir($folder)) {
                throw new InvalidArgumentException(sprintf('"%s" nie istnieje.'));
            }

            foreach (sfFinder::type('file')->name('*.png')->in($folder) as $file) {
                $files[] = $file;
            }
        }

        return $files;
    }

    /**
     * @see sfJSOptimizerBase
     */
    public function getAssetFilepath($file)
    {
        return $file;
    }
}
