<?php
/**
 * sfJSPlugin - optymalizacja CSS
 *
 * @package     sfJSPlugin
 * @subpackage  optimizer
 */
class sfJSOptimizerStylesheet extends sfJSOptimizerCombinableBase
{

    /**
     * Pobiera ścieżke do plików CSS.
     *
     * @see sfJSOptimizerBase
     */
    public function getAssetFilepath($file)
    {
        return parent::computeAssetFilepath($file, 'css', '/css');
    }

    /**
     * Przeprowadza optymalizację plików.
     *
     * @param  string  $file
     * @return array
     */
    public function optimizeFile($file)
    {
        return parent::getDriver($this->driver)
            ->reset()
            ->processFile($file, false)
            ->getResults();
    }
}