<?php

class sfJSPluginTools
{

  /**
   * Sprawdza czy podane jako argument parametry znajdują się na black liście. Zwraca tylko dozwolone routingi.
   *
   * @param array   $params, parametry do przefiltrowania sprawdzenia.
   * @return array
   **/
  public static function filterParameters($params)
  {
    $ret = array();

    // Pobiera black listę.
    $blacklist = sfConfig::get('app_sf_js_plugin_routing_params_blacklist', array('module', 'action'));

    foreach ($params as $name => $value) 
    {
      if (!in_array($name, $blacklist))
      {
        $ret[$name] = $value;
      }
    }

    return $ret;
  }
}
