<?php

/**
 * Task przeprowadzający optymalizację Assetów.
 *
 * @package     sfJSPLugin.
 * @subpackage  task
 * 
 * "http://csssprites.org/#usage".
 */
class sfCssSpritesTask extends sfBaseTask {

  protected function configure() {

    $this->namespace = 'optimize';
    $this->name = 'generate-sprites';
    $this->briefDescription = 'Generuje spraity z plików CSS';
    $this->aliases = array("gs");

    $this->addOptions(array(
        new sfCommandOption(
                'css-file-encoding', null, sfCommandOption::PARAMETER_OPTIONAL, 'CSS file encoding [VAL]', false
        ),
        new sfCommandOption(
                'css-file-suffix', null, sfCommandOption::PARAMETER_OPTIONAL, 'Plik CSS suffix [VAL]', false
        ),
        new sfCommandOption(
                'css-files', null, sfCommandOption::PARAMETER_OPTIONAL, 'Pliki CSS [FILES]', false
        ),
        new sfCommandOption(
                'document-root-dir-path', null, sfCommandOption::PARAMETER_OPTIONAL, 'Katalog web [DIR]', false
        ),
        new sfCommandOption(
                'log-level', null, sfCommandOption::PARAMETER_OPTIONAL, 'Poziom komuniktów [INFO | IE6NOTICE | DEPRECATION | WARN | ERROR | STATUS]', false
        ),
        new sfCommandOption(
                'output-dir-path', null, sfCommandOption::PARAMETER_OPTIONAL, 'Katalog docelowy [DIR]', false
        ),
        new sfCommandOption(
                'root-dir-path', null, sfCommandOption::PARAMETER_OPTIONAL, 'Katalog z plikami CSS [DIR]', false
        ),
        new sfCommandOption(
                'sprite-png-depth', null, sfCommandOption::PARAMETER_OPTIONAL, 'Sprite png depth [AUTO | INDEXED | DIRECT]', false
        ),
        new sfCommandOption(
                'no-log', null, sfCommandOption::PARAMETER_OPTIONAL, 'Bez logów', true
        ),
    ));


    $this->detailedDescription = <<<EOF
            
    Generuje spraity z plików CSS umieszczonych w katalogu /site/web/css
    Wywołanie taska:
      [php symfony sprites|INFO]

EOF;
  }

  protected function execute($arguments = array(), $options = array()) {

    if (isset($options['css-file-encoding']) && $options['css-file-encoding']) {
      $params[] = "--css-file-encoding " . $options['css-file-encoding'];
    }

    if (isset($options['css-file-suffix']) && $options['css-file-suffix']) {
      $params[] = "--css-file-suffix " . $options['css-file-suffix'];
    }

    if (isset($options['css-files']) && $options['css-files']) {
      $params[] = "--css-files " . $options['css-files'];
    } else {
      if (isset($options['root-dir-path']) && $options['root-dir-path']) {
        $params[] = "--root-dir-path " . $options['root-dir-path'];
      } else {
        $params[] = "--root-dir-path " . sfConfig::get("sf_web_dir");
      }
    }

    if (isset($options['log-level']) && $options['log-level']) {
      $params[] = "--log-level " . $options['log-level'];
    }

    if (isset($options['output-dir-path']) && $options['output-dir-path']) {
      $params[] = "--output-dir-path " . $options['output-dir-path'];
    }

    if (isset($options['sprite-png-depth']) && $options['sprite-png-depth']) {
      $params[] = "--sprite-png-depth " . $options['sprite-png-depth'];
    }

    if (isset($options['document-root-dir-path']) && $options['document-root-dir-path']) {
      $params[] = "--document-root-dir-path " . $options['document-root-dir-path'];
    } else {
      $params[] = "--document-root-dir-path " . sfConfig::get("sf_web_dir");
    }

    $params[] = "--sprite-png-ie6";
    $chdir = "cd " . dirname(__FILE__) . "/../vendor/smartsprites/";
    $command = $chdir . " && ./smartsprites.sh " . join(" ", $params);
    

    $this->logSection('sprite', 'Trwa łączenie obrazków w spraity (Proszę czekać...)', null, 'INFO');

    if (isset($options['no-log']) && $options['no-log']) {
      $this->getFilesystem()->execute($command);
    } else {
      $this->log($this->getFilesystem()->execute($command));
    }
  }

}
