<?php

/**
 * Task przeprowadzający optymalizację Assetów.
 *
 * @package     sfJSPLugin.
 * @subpackage  task
 * 
 */
class sfGenerateJavascriptsTask extends sfBaseTask {

    protected function configure() {

        $this->namespace = 'optimize';
        $this->name = 'generate-javascripts';
        $this->briefDescription = 'Generuje plik JS z akcji PHP';
        $this->aliases = array("gjs");

        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_OPTIONAL , 'The application name', 'frontend'),
        ));

        $this->detailedDescription = <<<EOF
            
    Generuje plik z javascriptami /site/web/js
    Wywołanie taska:
      [php symfony generate-javascripts|INFO]

EOF;
    }

    protected function execute($arguments = array(), $options = array()) {

        $this->logSection('javascript', 'Trwa generowanie pliku JS. (Proszę czekać...)', null, 'INFO');

        if ($this->configuration instanceof sfApplicationConfiguration) {
            sfContext::createInstance($this->configuration);
        }

        if (sfContext::hasInstance()) {
            $sf_controler = sfContext::getInstance()->getController();

            $fileContent = $sf_controler->getPresentationFor('sfJSi18n', 'i18nJs')
                    . $sf_controler->getPresentationFor('sfJSRouting', 'index');

            $fileName = sfConfig::get('sf_web_dir') . '/js/dynamic.js';

            file_put_contents($fileName, $fileContent);

            $this->logSection(
                    'file+', $fileName, null, 'COMMAND'
            );
        }
    }

}
