<?php

class PluginSfJSDynamicsActions extends artActions {

  /**
   * Akcja generuje dynamicznie Javascripty
   * 
   * @param sfWebRequest $request 
   */
  public function executeDynamicJavascripts(sfWebRequest $request) {

    $this->vars = $request->getGetParameters();
    $this->javascripts = $this->getJavascriptsFromModules();

    $this->getResponse()->addVaryHttpHeader('Cookie');
    $this->getResponse()->addVaryHttpHeader('User-Agent');
    $this->getResponse()->addVaryHttpHeader('Accept-Language');
    $this->getResponse()->setHttpHeader('Expires', $this->getResponse()->getDate(time() + 2592999));
    $this->getResponse()->setHttpHeader('Description', 'Dynamiczne JS generowane z poziomu PHP.');
  }

  /**
   * Zwraca javascypty generowane w akacjach. 
   * 
   * @return array with javascripts. 
   */
  public function getJavascriptsFromModules() {

    $javascripts = array();

    if (sfConfig::get('app_sf_assets_plugin_include_dynamics_javascripts_i18n', false)) {
      array_push($javascripts, $this->getController()->getPresentationFor('sfJSi18n', 'i18nJs'));
    }

    if (sfConfig::get('app_sf_assets_plugin_include_dynamics_javascripts_routing', false)) {
      array_push($javascripts, $this->getController()->getPresentationFor('sfJSRouting', 'index'));
    }

    return $javascripts;
  }

}
