<?php

require_once dirname(__FILE__) . '/../../../lib/request/sfJSResponder.php';

/**
 * Klasa z akcjami odpowiadjącymi za obsługę mechanizmu łączenia kilku requestów w 1, oraz 
 * tworząca odpowiedź w formacie obiektu JSON. 
 * 
 */
class PluginsfJSRequestActions extends artActions {
  
  /**
   * Routing odpowiadający za wczytanie kilku innych akcji, zwraca tablicę JSON z wartościami. 
   * 
   * @param sfWebRequest $request
   * @return string
   */
  public function executeSfJSRequest(sfWebRequest $request) {

    // sprawdzenie czy akcja jest wywołana ajaxem

    if ($request->isXmlHttpRequest()) {
      
      $modules = $request->getParameter('components', array());
      $routes = $this->getContext()->getRouting()->getRoutes();
      $js_response = array();

      foreach ($modules as $component => $module) {
        $route = $routes[$module['routing']];
        $module = $this->getRouteParameter($route, 'module');
        $action = $this->getRouteParameter($route, 'action');
        $options = $this->getRouteOptions($route);

        $js_response[$component] = $this->prepareResponse($module, $action, $options);
      }

      $this->getResponse()->setContentType('application/json');
      $this->renderText(json_encode($js_response));
      
      return sfView::NONE; 
      
    } else {
      // KOMUNIKAT O BŁĘDZIE/ 
      $this->renderText('To nie jest request AJAX');
    }
  }

  /**
   * Funkcja przygotowuje odpowiedź, w zależności od typu odpowiednio zapisuje wynik wykonania w tablicy. 
   * 
   * @param type $module
   * @param type $action
   * @param type $options
   * @return type
   */
  public function prepareResponse($module, $action, $options) {
    $type = $options['type'];
    $id = $options['id'];
    
    $execute = $this->getController()->getAction($module, $action);

    if ($type == "JSON") {
      $presentation = json_decode($this->getController()->getPresentationFor($module, $action));
    } else {
      $presentation = $this->getController()->getPresentationFor($module, $action);
    }

    return array(
        $type => array (
            'id' => $id, 
            'value' => $presentation
        )
    );
  }

  /**
   * Pobiera tablicę z opcjami dla danej definicji routingu. 
   * 
   * @param sfRoute $route
   * @return type
   */
  public function getRouteOptions(sfRoute $route) {

    return $route->getOptions();
  }

  /**
   * Zwraca wartość parametru z tablicy wartości domyslnych w routingu. [ moduł, akcja ];  
   * 
   * @param sfRoute $route
   * @param type $param
   * @return type
   */
  public function getRouteParameter(sfRoute $route, $param) {
    $params = $route->getDefaults();

    return $params[$param];
  }
  
}
