<?php

class sfJSRoutingActions extends sfActions
{

    /**
     * Zwraca listę routingów które mają być dostępne z poziomu JS.
     *
     * @param sfWebRequest $request
     * @return JavaScript
     */
    public function executeIndex(sfWebRequest $request)
    {
        $this->setLayout(FALSE); 

        $csrf = array();
        $form = new BaseForm();
        
        if ($form->isCSRFProtected())
        {
            $csrf[BaseForm::getCSRFFieldName()] = $form->getDefault(BaseForm::getCSRFFieldName());
        }

        $this->setVar('csrf', $csrf, true);

        $routing = $this->getContext()->getRouting();

        // ustawia zmienne.
        $routingOptions = $routing->getOptions();
        $this->setVar('options', $routingOptions, true);
        $this->setVar('defaultParameters', $routing->getDefaultParameters(), true);

        // Pobiera zmienne do wyświetlenia.
        $exposed_routes = array_merge(
            $this->autoDiscoverExposedRoutes($routing),
            $this->applicationConfiguredRoutes($routing));

        $this->setVar('routes', $exposed_routes, true);
    }

    /**
     * Metoda pobiera trasę i sprawdza czy może być ona wyświetlona.
     *
     * @param Nazwa routingu do sprawdzenia, wszystkie dostępne drogi.
     * @return sfRoute, lub null.
     **/
    protected function retrieveRoute($route_id, $routing)
    {
        if ($routing->hasRouteName($route_id))
        {
            $routes = $routing->getRoutes();
            $route = $routes[$route_id];
            $options = $route->getOptions();

            // Sprawdź czy pobrany routing ma być wyświetlony.
            if (!isset($options['visible_in_js']) || true === $options['visible_in_js'])
            {
                return $route;
            }
        }
        return null;
    }

    /**
     * Zwraca trasy skonfigurowane w aplikacji.
     *
     * @return array
     **/
    protected function applicationConfiguredRoutes($routing)
    {
        $routes = array();

        foreach (sfConfig::get('app_sf_js_plugin_routing_routes_to_expose', array()) as $route_id)
        {
            if ($route = $this->retrieveRoute($route_id, $routing))
            {
                $routes[$route_id] = $route;
            }
        }

        return $routes;
    }

    /**
     * Pokoleji sprawdza routing, szuka dostepne trasy,
     * sprawdza opcję *visible_in_js* czy jest usawiona na true i zwraca tyko takie trasy.
     *
     * @return array, lista tras.
     **/
    protected function autoDiscoverExposedRoutes($routing)
    {
        $routes = array();

        if (sfConfig::get('app_sf_js_plugin_routing_auto_discover', true))
        {
            foreach ($routing->getRoutes() as $route_id => $route)
            {
                $options = $route->getOptions();

                if (isset($options['visible_in_js']) && $options['visible_in_js'])
                {
                    $routes[$route_id] = $route;
                }
            }
        }

        return $routes;
    }
}
