<?php
/**
 * Komponent sfJSRouting.
 *
 * @package    sfJSPlugin
 * @subpackage sfJSRouting
 * @version     0.1-DEV
 *
 * Available options:
 *      variable_prefixes:                An array of characters that starts a variable name (: by default)
 *      segment_separators:               An array of allowed characters for segment separators (/ and . by default)
 *      variable_regex:                   A regex that match a valid variable name ([\w\d_]+ by default)
 *      generate_shortest_url:            Whether to generate the shortest URL possible (true by default)
 *      extra_parameters_as_query_string: Whether to generate extra parameters as a query string
 */
?>
var Routing = $.RoutingClass;

<?php foreach($routes as $id => $route): ?>
  Routing.connect(<?php echo json_encode($id); ?>,<?php echo json_encode($route->getPattern()); ?>,<?php echo json_encode(sfJSPluginTools::filterParameters($route->getDefaults())); ?>);
<?php endforeach; ?>

if (window.location.pathname.toLowerCase().indexOf("/frontend_dev.php") == 0)
  Routing.prefix = '/frontend_dev.php/';
else
  Routing.prefix = '/';
  
Routing.variablePrefix = <?php echo json_encode($options['variable_prefixes']); ?>;
Routing.variableSuffix = <?php echo json_encode($options['suffix']); ?>;
Routing.segmentSeparators = <?php echo json_encode($options['segment_separators']); ?>;
Routing.defaults = <?php echo json_encode(sfJSPluginTools::filterParameters($defaultParameters)); ?>;
Routing.csrf = <?php echo json_encode($csrf); ?>;
Routing.methodParameterName = "sf_method";