<?php

/**
 * PluginsfGuardUser form.
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage filter
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: PluginsfGuardUserFormFilter.class.php 23536 2009-11-02 21:41:21Z Kris.Wallsmith $
 */
abstract class PluginsfGuardUserFormFilter extends BasesfGuardUserFormFilter
{
  public function setup()
  {
    $this->setWidgets(array(
      'first_name' => new sfArtWidgetFormFilterInput(),
      'is_active' => new sfArtWidgetFormFilterBoolRadio(),
      'last_name' => new sfArtWidgetFormFilterInput(),
      'is_super_admin' => new sfArtWidgetFormFilterBoolRadio(),
      'email_address' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'is_banned' => new sfArtWidgetFormFilterBoolRadio(),
      'username' => new sfArtWidgetFormFilterInput(array('with_empty' => false)),
      'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardGroup')),
      'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission')),
    ));

    $this->setValidators(array(
      'first_name' => new sfValidatorPass(array('required' => false)),
      'last_name' => new sfValidatorPass(array('required' => false)),
      'email_address' => new sfValidatorPass(array('required' => false)),
      'username' => new sfValidatorPass(array('required' => false)),
      'is_active' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_banned' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'is_super_admin' => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
      'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('sf_guard_user_filters[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }
}
