<?php

/**
 * sfGuardRegisterForm for registering new users
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage form
 * @author     Jonathan H. Wage <jonwage@gmail.com>
 * @version    SVN: $Id: BasesfGuardChangeUserPasswordForm.class.php 23536 2009-11-02 21:41:21Z Kris.Wallsmith $
 */
class PluginsfGuardRegisterForm extends BasesfGuardUserForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'first_name' => new sfArtWidgetFormInputText(),
        'last_name' => new sfArtWidgetFormInputText(),
        'email_address' => new sfArtWidgetFormInputText(),
//      'username'                                                   => new sfArtWidgetFormInputText(),
        'password' => new sfArtWidgetFormInputPassword(),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'first_name' => new sfValidatorString(array('max_length' => 255)),
        'last_name' => new sfValidatorString(array('max_length' => 255)),
        'email_address' => new sfValidatorEmail(),
//      'username'                                                   => new sfValidatorString(array('max_length' => 128)),
        'password' => new sfValidatorString(array('max_length' => 128)),
    ));

    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Both password must be the same')));
    $this->validatorSchema->setPostValidator(
            new sfValidatorAnd(array(
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address'))),
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('username'))),
            ))
    );
    
    $this->widgetSchema['password_again'] = new sfArtWidgetFormInputPassword();
    $this->validatorSchema['password_again'] = clone $this->validatorSchema['password'];
    $this->validatorSchema['password_again']->setOption('required', true);
    
    if (!is_null($this->getOption('invitation', null)))
      $this->setWidget('invitation', new sfWidgetFormInputHidden());

    $this->setValidator('invitation', new sfValidatorPass());
    
    $this->widgetSchema->setNameFormat('sf_guard_user_register[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $custom_decorator = new sfWidgetFormSchemaFormatterDefault($this->getWidgetSchema());
    $this->getWidgetSchema()->addFormFormatter('Default', $custom_decorator);
    $this->getWidgetSchema()->setFormFormatterName('Default');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }
  
  public function save($con = null)
  {
    $user = parent::save($con);
    
    if (isset($this->values['invitation']))
      $user->invitationSuccess();
    
    return $user;
  }

}