<?php

/**
 * PluginsfGuardUser form.
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage form
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: PluginsfGuardUserForm.class.php 23536 2009-11-02 21:41:21Z Kris.Wallsmith $
 */
class PluginUserAdminForm extends BasesfGuardUserForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'first_name' => new sfArtWidgetFormInputText(),
        'last_name' => new sfArtWidgetFormInputText(),
        'email_address' => new sfArtWidgetFormInputText(),
        'username' => new sfArtWidgetFormInputText(),
        'is_active' => new sfWidgetFormInputCheckbox(),
        'is_banned' => new sfWidgetFormInputCheckbox(),
        'password_expired' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'first_name' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
        'last_name' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
        'email_address' => new sfValidatorString(array('max_length' => 255)),
        'username' => new sfValidatorString(array('max_length' => 128)),
        'is_active' => new sfValidatorBoolean(array('required' => false)),
        'is_banned' => new sfValidatorBoolean(array('required' => false)),
        'password_expired' => new sfValidatorDateTime(array('required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
            new sfValidatorAnd(array(
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address'))),
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('username'))),
            ))
    );

    $this->widgetSchema->setNameFormat('sf_guard_user[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  
  public function save($con = null)
  {
    $object = parent::save($con);
    
    if ($this->isNew())
    {
      $userDetail = new UserDetail();
      $object->setUserDetail($userDetail);
      $object->save();
    }
    
    return $object;
  }
}
