<?php

/**
 * Description of PluginUserPermissionsForm
 *
 
 */
class PluginUserPermissionsForm extends BasesfGuardUserForm
{

  public function setup()
  {
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'is_super_admin' => new sfWidgetFormInputCheckbox(),
        'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardGroup')),
        'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission', 'method' => 'getDescription')),
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'is_super_admin' => new sfValidatorBoolean(array('required' => false)),
        'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
        'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('sf_guard_user[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

}
