<?php

/**
 * sfGuardChangeUserPasswordForm for changing a users password
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage form
 * @author     Jonathan H. Wage <jonwage@gmail.com>
 * @version    SVN: $Id: sfGuardChangeUserPasswordForm.class.php 23536 2009-11-02 21:41:21Z Kris.Wallsmith $
 */
class sfGuardChangeUserPasswordForm extends BasesfGuardUserForm
{

  public function setup()
  {
    parent::setup();

    $this->setDivLevels();

    $this->useFields(array('password'));

    $this->widgetSchema['password'] = new sfArtWidgetFormInputPassword();
//    $this->widgetSchema['password'] = new sfWidgetFormInputPassword();
    $this->validatorSchema['password']->setOption('required', true);
    $this->widgetSchema['password_again'] = new sfArtWidgetFormInputPassword();
//    $this->widgetSchema['password_again'] = new sfWidgetFormInputPassword();
    $this->validatorSchema['password_again'] = clone $this->validatorSchema['password'];
    $this->validatorSchema['password_again']->setOption('required', true);

    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Both password must be the same')));
  }

  public function getLevelsArray()
  {
    $levels[] = array('password');
    $levels[] = array('password_again');

    return $levels;
  }

  public function save($con = null)
  {
    $this->values['is_active'] = 1;

    return parent::save($con);
  }

}