<?php

/**
 * sfGuardFormSignin for sfGuardAuth signin action
 *
 * @package    sfDoctrineGuardPlugin
 * @subpackage form
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfGuardFormSignin.class.php 23536 2009-11-02 21:41:21Z Kris.Wallsmith $
 */
class sfGuardFormSignin extends BaseForm {

  /**
   * @see sfForm
   */
  public function configure() {
    $this->setRequiredFields(false);

    $this->setWidgets(array(
        'username' => new sfWidgetFormInputText(),
        'password' => new sfWidgetFormInputPassword(array('type' => 'password')),
    ));
    $this->setValidators(array(
        'username' => new sfValidatorString(),
        'password' => new sfValidatorString(),
    ));


    if (sfConfig::get('app_sf_guard_plugin_remember_in_signin_form', true)) {
      $this->widgetSchema['remember'] = new sfWidgetFormInputCheckbox();
      $this->validatorSchema['remember'] = new sfValidatorBoolean();
    }

    if (sfConfig::get('app_sf_guard_plugin_allow_login_with_email', true)) {
      $this->widgetSchema['username']->setLabel('E-mail');
    }

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->validatorSchema->setPostValidator(new sfGuardValidatorUser());

    $this->widgetSchema->setNameFormat('signin[%s]');
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function getPartial() {
    return 'loginForm';
  }

  public function getIcon() {
    return 'megaicon1-lock';
  }

  public function getIsNarrow() {
    return true;
  }

  public function save($con = null) {
    sfContext::getInstance()->getUser()->signIn($this->values['user'], array_key_exists('remember', $this->values) ? $this->values['remember'] : false);
  }

}
