<?php

/**
 * Formularz zmiany hasla dla innego uzytkownika
 *
 * @package    sfDoctrineGuardPlugin

 */
class FlatyChangeUserPasswordForm extends BasesfGuardUserForm
{
  public function setup()
  {
    parent::setup();

    $this->setWidgets(array(
      'password' => new sfWidgetFormInputPassword(array('label' => 'Nowe hasło')),
      'password_again' => new sfWidgetFormInputPassword(array('label' => 'Nowe hasło (ponownie)')),
    ));
    
    $this->setValidators(array(
      'password' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
      'password_again' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
    ));
    
    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Oba hasła muszą być takie same')));
    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::NOT_EQUAL, 'old_password', array('throw_global_error' => true), array('invalid' => 'Aktualne i nowe hasło nie mogą być takie same')));

    $this->widgetSchema->setNameFormat('change_user_password[%s]');
    $this->disableRequiredsFieldText();
    
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }
  
  

  public function save($con = null) {
    $this->getObject()->setPassword($this->getValue('password'));
    $this->getObject()->save();
    // Nie ma potrzeby wywolywac parent::save($con) bo formularz juz nam nic nie zmienia
  }
}
