<?php

/**
 * Description of sfGuardChangeSigninPassword
 */
class sfGuardChangeSigninPasswordForm extends BasesfGuardUserForm
{

  public function setup()
  {
    parent::setup();

    $this->setWidgets(array(
      'old_password' => new sfWidgetFormInputPassword(array('label' => 'Aktualne hasło')),
      'password' => new sfWidgetFormInputPassword(array('label' => 'Nowe hasło')),
      'password_again' => new sfWidgetFormInputPassword(array('label' => 'Nowe hasło (ponownie)')),
    ));
    
    $this->setValidators(array(
      'old_password' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
      'password' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
      'password_again' => new sfValidatorString(array('min_length' => 4, 'max_length' => 128, 'required' => true), array('min_length' => 'Podane hasło jest za krótkie (minimun %min_length% znaków)', 'max_length' => 'Podane hasło jest za długie (maksimum %max_length% znaków)')),
    ));

    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Oba hasła muszą być takie same')));
    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::NOT_EQUAL, 'old_password', array('throw_global_error' => true), array('invalid' => 'Aktualne i nowe hasło nie mogą być takie same')));
    $this->mergePostValidator(new artGuardPasswordValidator('old_password', $this->getObject()));

    $this->widgetSchema->setNameFormat('change_password[%s]');
    $this->disableRequiredsFieldText();
//    $custom_decorator = new sfWidgetFormSchemaFormatterDefault($this->getWidgetSchema());
//    $this->getWidgetSchema()->addFormFormatter('Default', $custom_decorator);
    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }
    
    $this->widgetSchema->setHelp('slug', 'Will be generated automatically.');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
  
  

  public function save($con = null) {
    $this->getObject()->setPassword($this->getValue('password'));
    $this->getObject()->save();
    // Nie ma potrzeby wywolywac parent::save($con) bo formularz juz nam nic nie zmienia
  }
    public function getIcon() {
    return 'megaicon1-key';
  }

}
